/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.township.manage.bootstrap;

import cn.smarthse.township.manage.bootstrap.properties.JwtProperties;
import cn.smarthse.township.manage.bootstrap.security.filter.JwtFilter;
import cn.smarthse.township.manage.bootstrap.security.realms.CasRealm;
import cn.smarthse.township.manage.bootstrap.security.realms.CustomModularRealmAuthenticator;
import cn.smarthse.township.manage.bootstrap.security.realms.JwtRealm;
import cn.smarthse.township.manage.bootstrap.security.realms.PasswordRealm;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.spring.boot.autoconfigure.ShiroAutoConfiguration;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureBefore(value={ShiroAutoConfiguration.class})
public class ShiroConfig {
    private final JwtProperties jwtProperties;

    @Bean(value={"hashedCredentialsMatcher"})
    public HashedCredentialsMatcher hashedCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher();
        matcher.setHashAlgorithmName("SHA-1");
        matcher.setHashIterations(1024);
        matcher.setStoredCredentialsHexEncoded(true);
        return matcher;
    }

    @Bean
    public PasswordRealm passwordRealm(@Qualifier(value="hashedCredentialsMatcher") HashedCredentialsMatcher matcher) {
        PasswordRealm userRealm = new PasswordRealm();
        userRealm.setCredentialsMatcher((CredentialsMatcher)matcher);
        return userRealm;
    }

    @Bean
    public JwtRealm jwtRealm() {
        return new JwtRealm();
    }

    @Bean
    public CasRealm casRealm() {
        return new CasRealm();
    }

    @Bean(value={"shiroFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilter(@Qualifier(value="sessionsSecurityManager") SecurityManager securityManager) {
        ShiroFilterFactoryBean bean = new ShiroFilterFactoryBean();
        bean.setSecurityManager(securityManager);
        LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
        filterMap.put("/admin/login/**", "anon");
        filterMap.put("/manage/login/**", "anon");
        filterMap.put("/m/login/**", "anon");
        filterMap.put("/m/zwdd/**", "anon");
        filterMap.put("/company/login/**", "anon");
        filterMap.put("/api/**", "anon");
        filterMap.put("/static/**", "anon");
        filterMap.put("/upload/**", "anon");
        filterMap.put("/swagger-ui.html", "anon");
        filterMap.put("/swagger-ui/**", "anon");
        filterMap.put("/swagger-resources/**", "anon");
        filterMap.put("/img/**", "anon");
        filterMap.put("/webjars/**", "anon");
        filterMap.put("/doc.html", "anon");
        filterMap.put("/v3/api-docs/**", "anon");
        LinkedHashMap<String, JwtFilter> filter = new LinkedHashMap<String, JwtFilter>(1);
        filter.put("jwt", new JwtFilter(this.jwtProperties));
        bean.setFilters(filter);
        filterMap.put("/**", "jwt");
        bean.setFilterChainDefinitionMap(filterMap);
        return bean;
    }

    @Bean
    public Authenticator authenticator() {
        CustomModularRealmAuthenticator modularRealmAuthenticator = new CustomModularRealmAuthenticator();
        modularRealmAuthenticator.setAuthenticationStrategy((AuthenticationStrategy)new AtLeastOneSuccessfulStrategy());
        return modularRealmAuthenticator;
    }

    @Bean
    public SessionsSecurityManager sessionsSecurityManager(@Qualifier(value="passwordRealm") PasswordRealm passwordRealm, @Qualifier(value="jwtRealm") JwtRealm jwtRealm, @Qualifier(value="casRealm") CasRealm casRealm, @Qualifier(value="authenticator") Authenticator authenticator) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setAuthenticator(authenticator);
        ArrayList<AuthorizingRealm> realms = new ArrayList<AuthorizingRealm>();
        realms.add(passwordRealm);
        realms.add(jwtRealm);
        realms.add(casRealm);
        securityManager.setRealms(realms);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
        return securityManager;
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Generated
    public ShiroConfig(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }
}

