/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.wcsp.controller;

import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.wcsp.service.WcspEncryptionService;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/crypto"})
public class WcspController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspController.class);
    private static final String BASE64 = "BASE64";
    private static final String HEX = "HEX";
    private final WcspEncryptionService wcspEncryptionService;

    @GetMapping(value={"encrypt"})
    public ResponseEntity<String> encrypt(@RequestParam(required=false) String encodeType, @RequestParam String data) {
        try {
            String encrypt = Objects.equals(encodeType, HEX) ? EncryptUtils.encryptByWcspLightDataServiceHex((String)data) : EncryptUtils.encryptByWcspLightDataService((String)data);
            return ResponseEntity.ok((Object)encrypt);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("\u52a0\u5bc6\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"decrypt"})
    public ResponseEntity<String> decrypt(@RequestParam(required=false) String encodeType, @RequestParam String data) {
        try {
            String decrypt = Objects.equals(encodeType, HEX) ? EncryptUtils.decryptByWcspLightDataServiceHex((String)data) : EncryptUtils.decryptByWcspLightDataService((String)data);
            return ResponseEntity.ok((Object)decrypt);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("\u89e3\u5bc6\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"getKeyId"})
    public ResponseEntity<String> getKeyId(@RequestParam String alias, @RequestParam(required=false) String description) {
        try {
            return ResponseEntity.ok((Object)this.wcspEncryptionService.getKeyId(alias, description));
        }
        catch (Exception e) {
            log.error("getKeyId\u5931\u8d25: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("getKeyId\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Generated
    public WcspController(WcspEncryptionService wcspEncryptionService) {
        this.wcspEncryptionService = wcspEncryptionService;
    }
}

