/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.wcsp.config;

import cn.smarthse.encrypt.context.WcspEncryptContext;
import cn.smarthse.encrypt.pool.WcspCryptoServicePlatformPool;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.wcsp.config.properties.WcspProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WcspProperties.class})
public class WcspConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspConfig.class);
    private final WcspProperties wcspProperties;

    @Bean(destroyMethod="close")
    public WcspCryptoServicePlatformPool wcspCryptoServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptUtils \u914d\u7f6e");
        WcspEncryptContext context = new WcspEncryptContext();
        context.setUrl(this.wcspProperties.getUrl());
        context.setTenantId(this.wcspProperties.getTenantId());
        context.setAppId(this.wcspProperties.getAppId());
        context.setSecret(this.wcspProperties.getSecret());
        context.setWorkDir(this.wcspProperties.getWorkDir());
        context.setPoolMaxTotal(this.wcspProperties.getPoolMaxTotal());
        context.setPoolMaxIdle(this.wcspProperties.getPoolMaxIdle());
        context.setPoolMinIdle(this.wcspProperties.getPoolMinIdle());
        context.setPoolMaxWaitMillis(this.wcspProperties.getPoolMaxWaitMillis());
        context.setVersion(this.wcspProperties.getVersion());
        context.setKeyId(this.wcspProperties.getKeyId());
        WcspCryptoServicePlatformPool pool = new WcspCryptoServicePlatformPool(context);
        EncryptUtils.wcspInitialize((WcspCryptoServicePlatformPool)pool);
        return pool;
    }

    @Generated
    public WcspConfig(WcspProperties wcspProperties) {
        this.wcspProperties = wcspProperties;
    }
}

