/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.wcsp.config;

import cn.smarthse.core.wcsp.context.WcspContext;
import cn.smarthse.core.wcsp.pool.WcspServicePlatformPool;
import cn.smarthse.core.wcsp.utils.WcspEncryptionUtils;
import cn.smarthse.framework.wcsp.config.properties.WcspProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WcspProperties.class})
public class WcspConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspConfig.class);
    private final WcspProperties wcspProperties;

    @Bean(destroyMethod="close")
    public WcspServicePlatformPool wcspServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptionUtils \u914d\u7f6e");
        WcspContext wcspContext = new WcspContext();
        wcspContext.setWcspUrl(this.wcspProperties.getWcspUrl());
        wcspContext.setWcspTenantId(this.wcspProperties.getWcspTenantId());
        wcspContext.setWcspAppId(this.wcspProperties.getWcspAppId());
        wcspContext.setWcspSecret(this.wcspProperties.getWcspSecret());
        wcspContext.setWcspWorkDir(this.wcspProperties.getWcspWorkDir());
        wcspContext.setWcspPoolMaxTotal(this.wcspProperties.getWcspPoolMaxTotal());
        wcspContext.setWcspPoolMaxIdle(this.wcspProperties.getWcspPoolMaxIdle());
        wcspContext.setWcspPoolMinIdle(this.wcspProperties.getWcspPoolMinIdle());
        wcspContext.setWcspPoolMaxWaitMillis(this.wcspProperties.getWcspPoolMaxWaitMillis());
        wcspContext.setWcspAlias(this.wcspProperties.getWcspAlias());
        wcspContext.setWcspDescription(this.wcspProperties.getWcspDescription());
        wcspContext.setWcspVersion(this.wcspProperties.getWcspVersion());
        WcspServicePlatformPool pool = new WcspServicePlatformPool(wcspContext);
        WcspEncryptionUtils.initialize((WcspServicePlatformPool)pool);
        return pool;
    }

    @Generated
    public WcspConfig(WcspProperties wcspProperties) {
        this.wcspProperties = wcspProperties;
    }
}

