/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.core;

import cn.hutool.core.date.DateTime;
import cn.smarthse.framework.core.utils.DateUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class ControllerSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    protected void binderDefault(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(text.trim());
                }
            }
        });
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    int value = "true".equalsIgnoreCase(text.trim()) ? 1 : ("false".equalsIgnoreCase(text.trim()) ? 0 : Integer.parseInt(text.trim()));
                    this.setValue(value);
                }
            }
        });
        binder.registerCustomEditor(Byte.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(Byte.valueOf(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(new BigDecimal(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(Long.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(Long.valueOf(text.trim()));
                }
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    DateTime parse = DateUtils.parse((CharSequence)text);
                    this.setValue(Objects.isNull(parse) ? null : parse.toJdkDate());
                }
            }
        });
        binder.registerCustomEditor(LocalDateTime.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    DateTime parse = DateUtils.parse((CharSequence)text);
                    this.setValue(Objects.isNull(parse) ? null : parse.toLocalDateTime());
                }
            }
        });
        binder.registerCustomEditor(LocalDate.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    DateTime parse = DateUtils.parse((CharSequence)text);
                    this.setValue(Objects.isNull(parse) ? null : parse.toLocalDateTime().toLocalDate());
                }
            }
        });
        binder.registerCustomEditor(LocalTime.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    DateTime parse = DateUtils.parse((CharSequence)text);
                    this.setValue(Objects.isNull(parse) ? null : parse.toLocalDateTime().toLocalTime());
                }
            }
        });
    }
}

