/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.smarthse.framework.core.utils.DateUtils;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.web.config.properties.CorsProperties;
import cn.smarthse.framework.web.handler.SmarthseExceptionHandler;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={CorsProperties.class})
public class GeneralAutoConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneralAutoConfig.class);
    private final CorsProperties corsProperties;

    public void addInterceptors(InterceptorRegistry registry) {
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter(String.class, Date.class, source -> {
            DateTime parse = DateUtils.parse((CharSequence)source);
            if (ObjectUtils.isNull((Object)parse)) {
                return null;
            }
            return parse.toJdkDate();
        });
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    @Bean
    public SmarthseExceptionHandler smarthseExceptionHandler() {
        return new SmarthseExceptionHandler();
    }

    @Bean
    public CorsFilter corsFilter() {
        log.info("\u521d\u59cb\u5316 CorsFilter \u914d\u7f6e");
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(this.corsProperties.getAllowCredentials());
        if (CollUtil.isNotEmpty(this.corsProperties.getAllowedOriginPatterns())) {
            for (String originPattern : this.corsProperties.getAllowedOriginPatterns()) {
                config.addAllowedOriginPattern(originPattern);
            }
        } else {
            config.addAllowedOriginPattern("*");
        }
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        config.setMaxAge(Long.valueOf(1800L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Generated
    public GeneralAutoConfig(CorsProperties corsProperties) {
        this.corsProperties = corsProperties;
    }
}

