/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.config;

import cn.smarthse.framework.web.config.properties.XssProperties;
import cn.smarthse.framework.web.filter.RepeatableFilter;
import cn.smarthse.framework.web.filter.SecurityHeaderFilter;
import cn.smarthse.framework.web.filter.XssFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={XssProperties.class})
public class FilterAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilterAutoConfig.class);

    @Bean
    public FilterRegistrationBean<SecurityHeaderFilter> securityHeaderFilterRegistration() {
        log.info("\u521d\u59cb\u5316 SecurityHeaderFilter \u914d\u7f6e");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SecurityHeaderFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("securityHeaderFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    @Bean
    @ConditionalOnProperty(value={"xss.enabled"}, havingValue="true")
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        log.info("\u521d\u59cb\u5316 XssFilter \u914d\u7f6e");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new XssFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("xssFilter");
        registration.setOrder(-2147483647);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<RepeatableFilter> repeatableFilterRegistration() {
        log.info("\u521d\u59cb\u5316 RepeatableFilter \u914d\u7f6e");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RepeatableFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("repeatableFilter");
        registration.setOrder(0x7FFFFFFE);
        return registration;
    }
}

