/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.filter;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private final ObjectMapper mapper;

    public XssHttpServletRequestWrapper(HttpServletRequest request, ObjectMapper mapper) {
        super(request);
        this.mapper = mapper;
    }

    public String getParameter(String name) {
        return this.getTrim(super.getParameter(name));
    }

    private String getTrim(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return "";
        }
        if (StrUtil.isBlank((CharSequence)(value = HtmlUtil.filter((String)value)))) {
            return "";
        }
        if (StrUtil.isBlank((CharSequence)(value = HtmlUtil.cleanHtmlTag((String)value)))) {
            return "";
        }
        return value.trim();
    }

    public Map<String, String[]> getParameterMap() {
        Map valueMap = super.getParameterMap();
        if (MapUtil.isEmpty((Map)valueMap)) {
            return valueMap;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(valueMap.size());
        map.putAll(valueMap);
        for (Map.Entry entry : map.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values == null) continue;
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = this.getTrim(values[i]);
            }
            map.put((String)entry.getKey(), escapseValues);
        }
        return map;
    }

    public String[] getParameterValues(String name) {
        Object[] values = super.getParameterValues(name);
        if (ArrayUtil.isEmpty((Object[])values)) {
            return values;
        }
        int length = values.length;
        String[] escapseValues = new String[length];
        for (int i = 0; i < length; ++i) {
            escapseValues[i] = this.getTrim((String)values[i]);
        }
        return escapseValues;
    }

    public ServletInputStream getInputStream() throws IOException {
        boolean isXml;
        String contentType = super.getContentType();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return super.getInputStream();
        }
        boolean isJson = StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/json");
        boolean bl = isXml = StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/xml") || StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"text/xml");
        if (!isJson && !isXml) {
            return super.getInputStream();
        }
        String body = StrUtil.str((byte[])IoUtil.readBytes((InputStream)super.getInputStream(), (boolean)false), (Charset)StandardCharsets.UTF_8);
        if (StringUtils.isEmpty((String)body)) {
            return super.getInputStream();
        }
        String cleanedBody = this.escapeJsonStringValues(body);
        final byte[] bytes = cleanedBody.getBytes(StandardCharsets.UTF_8);
        final ByteArrayInputStream bis = IoUtil.toStream((byte[])bytes);
        return new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public int available() throws IOException {
                return bytes.length;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return bis.read();
            }
        };
    }

    private String escapeJsonStringValues(String jsonStr) {
        try {
            JsonNode rootNode = this.mapper.readTree(jsonStr);
            JsonNode escapedNode = this.traverseAndEscape(rootNode, false);
            return this.mapper.writeValueAsString((Object)escapedNode);
        }
        catch (Exception e) {
            log.error("Error clean and filter JSON string values: {}", (Object)e.getMessage(), (Object)e);
            return jsonStr;
        }
    }

    private JsonNode traverseAndEscape(JsonNode node, boolean isNested) {
        if (node.isTextual()) {
            if (isNested) {
                return new TextNode(this.getTrim(node.asText()));
            }
            return node;
        }
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            Iterator fields = objectNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                objectNode.set((String)entry.getKey(), this.traverseAndEscape((JsonNode)entry.getValue(), true));
            }
            return objectNode;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (int i = 0; i < arrayNode.size(); ++i) {
                arrayNode.set(i, this.traverseAndEscape(arrayNode.get(i), true));
            }
            return arrayNode;
        }
        return node;
    }
}

