/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StreamUtils;
import com.fasterxml.jackson.core.JsonParseException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@RestControllerAdvice
public class SmarthseExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmarthseExceptionHandler.class);

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseData<Object> dealException(ConstraintViolationException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u53c2\u6570\u6821\u9a8c\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
        r.setMessage(StreamUtils.join((Collection)e.getConstraintViolations(), ConstraintViolation::getMessage, (CharSequence)", "));
        r.setResult((Object)StreamUtils.toMap((Collection)e.getConstraintViolations(), i -> {
            String path = i.getPropertyPath().toString();
            return path.substring(path.indexOf(".") + 1);
        }, ConstraintViolation::getMessage));
        return r;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseData<Object> dealException(MethodArgumentNotValidException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u53c2\u6570\u6821\u9a8c\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
        r.setMessage(StreamUtils.join((Collection)e.getAllErrors(), DefaultMessageSourceResolvable::getDefaultMessage, (CharSequence)", "));
        r.setResult((Object)StreamUtils.toMap((Collection)e.getAllErrors(), i -> {
            FieldError fieldError = (FieldError)i;
            return fieldError.getField();
        }, DefaultMessageSourceResolvable::getDefaultMessage));
        return r;
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseData<Object> dealException(BindException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u53c2\u6570\u7ed1\u5b9a\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
        r.setMessage(StreamUtils.join((Collection)e.getAllErrors(), DefaultMessageSourceResolvable::getDefaultMessage, (CharSequence)", "));
        r.setResult((Object)StreamUtils.toMap((Collection)e.getAllErrors(), i -> {
            FieldError fieldError = (FieldError)i;
            return fieldError.getField();
        }, DefaultMessageSourceResolvable::getDefaultMessage));
        return r;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseData<Object> dealException(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.METHOD_NOT_ALLOWED.getValue());
        r.setMessage(e.getMessage());
        return r;
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseData<Object> dealException(MethodArgumentTypeMismatchException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
        r.setMessage(String.format("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53c2\u6570[%s]\u8981\u6c42\u7c7b\u578b\u4e3a\uff1a'%s'\uff0c\u4f46\u8f93\u5165\u503c\u4e3a\uff1a'%s'", e.getName(), e.getRequiredType().getName(), e.getValue()));
        return r;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseData<Object> dealException(MaxUploadSizeExceededException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236");
        return r;
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public ResponseData<Object> dealException(NoResourceFoundException e, HttpServletRequest request) {
        log.debug("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u8d44\u6e90\u4e0d\u5b58\u5728, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.NOT_FOUND.getValue());
        r.setMessage(ResponseStateEnum.NOT_FOUND.getName());
        return r;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseData<Object> dealException(HttpMessageNotReadableException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u8bf7\u6c42\u4f53\u8bfb\u53d6\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={JsonParseException.class})
    public ResponseData<Object> dealException(JsonParseException e, HttpServletRequest request) {
        log.warn("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: JSON \u89e3\u6790\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={ServletException.class})
    public ResponseData<Object> dealException(ServletException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: Servlet\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={IOException.class})
    public ResponseData<Object> dealException(IOException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u8fde\u63a5\u4e2d\u65ad, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseData<Object> dealException(RuntimeException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u8fd0\u884c\u65f6\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseData<Object> dealException(Exception e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u901a\u7528\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={ServiceException.class})
    public ResponseData<Object> dealException(ServiceException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42IP'{}', User-Agent'{}', \u8bf7\u6c42\u5730\u5740'{}', \u5f02\u5e38\u7c7b: {}, \u5f02\u5e38\u7c7b\u578b: \u4e1a\u52a1\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{Objects.nonNull(request) ? ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]) : "unknown", ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        Integer code = e.getCode();
        r.setState(Objects.isNull(code) ? ResponseStateEnum.fail.getValue() : code);
        r.setMessage(e.getMessage());
        r.setResult(e.getResult());
        return r;
    }
}

