/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.filter;

import cn.hutool.http.HtmlUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletResponseWrapper.class);
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final ServletOutputStream servletOutputStream = this.getOutputStream();
    private final PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.byteArrayOutputStream));
    private final ObjectMapper mapper;

    public XssHttpServletResponseWrapper(HttpServletResponse response, ObjectMapper mapper) throws IOException {
        super(response);
        this.mapper = mapper;
    }

    public PrintWriter getWriter() {
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public void reset() {
        this.byteArrayOutputStream.reset();
    }

    public byte[] getResponseData() throws IOException {
        this.flushBuffer();
        return this.byteArrayOutputStream.toByteArray();
    }

    public String getContent() throws IOException {
        this.flushBuffer();
        String content = this.byteArrayOutputStream.toString(StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        String contentType = this.getResponse().getContentType();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return content;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/xml") || StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"text/xml")) {
            return HtmlUtil.escape((String)content);
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/json")) {
            return this.escapeJsonStringValues(content);
        }
        return content;
    }

    private String escapeJsonStringValues(String jsonStr) {
        try {
            JsonNode rootNode = this.mapper.readTree(jsonStr);
            JsonNode escapedNode = this.traverseAndEscape(rootNode, false);
            return this.mapper.writeValueAsString((Object)escapedNode);
        }
        catch (Exception e) {
            log.error("Error escaping JSON string values: {}", (Object)e.getMessage(), (Object)e);
            return jsonStr;
        }
    }

    private JsonNode traverseAndEscape(JsonNode node, boolean isNested) {
        if (node.isTextual()) {
            if (isNested) {
                return new TextNode(HtmlUtil.escape((String)node.asText()));
            }
            return node;
        }
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            Iterator fields = objectNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                objectNode.set((String)entry.getKey(), this.traverseAndEscape((JsonNode)entry.getValue(), true));
            }
            return objectNode;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (int i = 0; i < arrayNode.size(); ++i) {
                arrayNode.set(i, this.traverseAndEscape(arrayNode.get(i), true));
            }
            return arrayNode;
        }
        return node;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                XssHttpServletResponseWrapper.this.byteArrayOutputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                XssHttpServletResponseWrapper.this.byteArrayOutputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                XssHttpServletResponseWrapper.this.byteArrayOutputStream.write(b, off, len);
            }
        };
    }
}

