/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.filter;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.json.utils.JsonUtils;
import cn.smarthse.framework.web.config.properties.XssProperties;
import cn.smarthse.framework.web.filter.XssHttpServletRequestWrapper;
import cn.smarthse.framework.web.filter.XssHttpServletResponseWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class XssFilter
implements Filter {
    public List<String> excludes = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        XssProperties properties = (XssProperties)SpringUtils.getBean(XssProperties.class);
        this.excludes.addAll(properties.getExcludeUrls());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        String requestURI = servletRequest.getRequestURI();
        String sanitizedRequestURI = HtmlUtil.cleanHtmlTag((String)HtmlUtil.filter((String)requestURI)).trim();
        if (!sanitizedRequestURI.equals(requestURI)) {
            HandlerExceptionResolver exceptionResolver = (HandlerExceptionResolver)SpringUtils.getBean((String)"handlerExceptionResolver", HandlerExceptionResolver.class);
            exceptionResolver.resolveException(servletRequest, servletResponse, null, (Exception)new ServiceException("\u975e\u6cd5\u8bf7\u6c42"));
        }
        if (this.handleExcludeURL(servletRequest, servletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper requestWrapper = new XssHttpServletRequestWrapper((HttpServletRequest)request, JsonUtils.getObjectMapper());
        XssHttpServletResponseWrapper xssResponse = new XssHttpServletResponseWrapper(servletResponse, JsonUtils.getObjectMapper());
        chain.doFilter((ServletRequest)ObjectUtil.defaultIfNull((Object)((Object)requestWrapper), (Object)request), (ServletResponse)ObjectUtil.defaultIfNull((Object)((Object)xssResponse), (Object)response));
        servletResponse.getWriter().write(xssResponse.getContent());
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response) {
        String url = request.getServletPath();
        return StringUtils.matches((String)url, this.excludes);
    }

    public void destroy() {
    }
}

