/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StreamUtils;
import com.fasterxml.jackson.core.JsonParseException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class SmarthseExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmarthseExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseData<Object> dealException(Exception ex) {
        String requestURI;
        ResponseData r = new ResponseData();
        HttpServletRequest request = ServletUtils.getRequest();
        String string = requestURI = request != null ? request.getRequestURI() : "";
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException e = (ConstraintViolationException)ex;
            Set message = e.getConstraintViolations();
            HashMap map = new HashMap();
            message.forEach(msg -> {
                String path = msg.getPropertyPath().toString();
                String field = path.substring(path.indexOf(".") + 1);
                map.put(field, msg.getMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
            r.setMessage(StreamUtils.join((Collection)e.getConstraintViolations(), ConstraintViolation::getMessage, (CharSequence)", "));
            r.setResult(map);
        } else if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException e = (MethodArgumentNotValidException)ex;
            List allErrors = e.getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
            r.setMessage(StreamUtils.join((Collection)e.getBindingResult().getAllErrors(), DefaultMessageSourceResolvable::getDefaultMessage, (CharSequence)", "));
            r.setResult(map);
        } else if (ex instanceof BindException) {
            BindException e = (BindException)ex;
            List allErrors = e.getBindingResult().getAllErrors();
            HashMap map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
            r.setMessage(StreamUtils.join((Collection)e.getAllErrors(), DefaultMessageSourceResolvable::getDefaultMessage, (CharSequence)", "));
            r.setResult(map);
        } else if (ex instanceof ServiceException) {
            ServiceException e = (ServiceException)ex;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',ServiceException.", (Object)requestURI, (Object)ex);
            Integer code = e.getCode();
            r.setState(Objects.isNull(code) ? ResponseStateEnum.fail.getValue() : code);
            r.setMessage(ex.getMessage());
            r.setResult(e.getResult());
        } else if (ex instanceof HealthException) {
            HealthException e = (HealthException)ex;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',HealthException.", (Object)requestURI, (Object)ex);
            ErrorEnum errorEnum = e.getError();
            if (Objects.isNull(errorEnum)) {
                r.setState(ResponseStateEnum.fail.getValue());
            } else {
                Integer code = errorEnum.getCode();
                r.setState(Objects.equals(code, ErrorEnum.defaultError.getCode()) ? ResponseStateEnum.fail.getValue() : code);
            }
            r.setMessage(e.getMessage());
            r.setResult((Object)e.getMessage());
        } else if (ex instanceof RpcException) {
            RpcException e = (RpcException)ex;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',RPC\u5f02\u5e38.", (Object)requestURI, (Object)e);
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage("RPC\u670d\u52a1\u9519\u8bef\uff01");
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            HttpRequestMethodNotSupportedException e = (HttpRequestMethodNotSupportedException)ex;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u4e0d\u652f\u6301'{}'\u8bf7\u6c42", (Object)requestURI, (Object)e.getMethod());
            r.setState(ResponseStateEnum.HTTP_BAD_METHOD.getValue());
            r.setMessage(ex.getMessage());
        } else if (ex instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException e = (MethodArgumentTypeMismatchException)ex;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d,\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)ex);
            r.setState(ResponseStateEnum.BAD_REQUEST.getValue());
            r.setMessage(String.format("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53c2\u6570[%s]\u8981\u6c42\u7c7b\u578b\u4e3a\uff1a'%s'\uff0c\u4f46\u8f93\u5165\u503c\u4e3a\uff1a'%s'", e.getName(), e.getRequiredType().getName(), e.getValue()));
        } else if (ex instanceof IOException) {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u8fde\u63a5\u4e2d\u65ad", (Object)requestURI, (Object)ex);
            r.setState(ResponseStateEnum.fail.getValue());
            r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        } else if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException e = (HttpMessageNotReadableException)ex;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53c2\u6570\u89e3\u6790\u5931\u8d25: {}", (Object)requestURI, (Object)e.getMessage());
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMostSpecificCause().getMessage());
        } else if (ex instanceof MaxUploadSizeExceededException) {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',MaxUploadSizeExceededException.", (Object)requestURI, (Object)ex);
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage("\u6587\u4ef6\u592a\u5927\uff01");
        } else if (ex instanceof ServletException) {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',ServletException.", (Object)requestURI, (Object)ex);
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        } else {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u672a\u77e5\u5f02\u5e38.", (Object)requestURI, (Object)ex);
            r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
            r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        }
        return r;
    }

    @ExceptionHandler(value={JsonParseException.class})
    public ResponseData<Object> handleJsonParseException(JsonParseException e, HttpServletRequest request) {
        ResponseData r = new ResponseData();
        String requestURI = request != null ? request.getRequestURI() : "";
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f JSON \u89e3\u6790\u5f02\u5e38: {}", (Object)requestURI, (Object)e.getMessage());
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }
}

