/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.web.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=0x7FFFFFFE)
@RestControllerAdvice
public class SmarthseCDExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmarthseCDExceptionHandler.class);

    @ExceptionHandler(value={HealthException.class})
    public ResponseData<Object> dealException(HealthException e, HttpServletRequest request) {
        if (!Objects.nonNull(request)) {
            log.warn("[Business] [HealthException] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Business] [HealthException] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData r = new ResponseData();
        ErrorEnum errorEnum = e.getError();
        if (Objects.isNull(errorEnum)) {
            r.setState(ResponseStateEnum.fail.getValue());
        } else {
            Integer code = errorEnum.getCode();
            r.setState(Objects.equals(code, ErrorEnum.defaultError.getCode()) ? ResponseStateEnum.fail.getValue() : code);
        }
        r.setMessage(e.getMessage());
        r.setResult((Object)e.getMessage());
        return r;
    }
}

