/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.shiro.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.ConcurrentAccessException;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=0x7FFFFFFE)
@RestControllerAdvice
public class ShiroExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroExceptionHandler.class);

    @ExceptionHandler(value={ConcurrentAccessException.class})
    public ResponseData<Object> handleConcurrentAccessException(ConcurrentAccessException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [ConcurrentAccess] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [ConcurrentAccess] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.CONCURRENT_LOGIN.getValue());
        responseData.setMessage(ResponseStateEnum.CONCURRENT_LOGIN.getName());
        return responseData;
    }

    @ExceptionHandler(value={ExpiredCredentialsException.class})
    public ResponseData<Object> handleExpiredCredentialsException(ExpiredCredentialsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [ExpiredCredentials] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [ExpiredCredentials] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue());
        responseData.setMessage(ResponseStateEnum.CREDENTIALS_EXPIRED.getName());
        return responseData;
    }

    @ExceptionHandler(value={CredentialsException.class})
    public ResponseData<Object> handleCredentialsException(CredentialsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [Credentials] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [Credentials] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.ACCOUNT_EXPIRED.getValue());
        responseData.setMessage(ResponseStateEnum.ACCOUNT_EXPIRED.getName());
        return responseData;
    }

    @ExceptionHandler(value={IncorrectCredentialsException.class})
    public ResponseData<Object> handleIncorrectCredentialsException(IncorrectCredentialsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [IncorrectCredentials] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [IncorrectCredentials] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue());
        responseData.setMessage(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        return responseData;
    }

    @ExceptionHandler(value={LockedAccountException.class})
    public ResponseData<Object> handleLockedAccountException(LockedAccountException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [LockedAccount] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [LockedAccount] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.ACCOUNT_LOCKED.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.ACCOUNT_LOCKED.getName());
        return responseData;
    }

    @ExceptionHandler(value={DisabledAccountException.class})
    public ResponseData<Object> handleDisabledAccountException(DisabledAccountException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [DisabledAccount] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [DisabledAccount] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.ACCOUNT_DISABLED.getValue());
        responseData.setMessage(ResponseStateEnum.ACCOUNT_DISABLED.getName());
        return responseData;
    }

    @ExceptionHandler(value={ExcessiveAttemptsException.class})
    public ResponseData<Object> handleExcessiveAttemptsException(ExcessiveAttemptsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [ExcessiveAttempts] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [ExcessiveAttempts] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.EXCESSIVE_ATTEMPTS.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.EXCESSIVE_ATTEMPTS.getName());
        return responseData;
    }

    @ExceptionHandler(value={UnknownAccountException.class})
    public ResponseData<Object> handleUnknownAccountException(UnknownAccountException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [UnknownAccount] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [UnknownAccount] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue());
        responseData.setMessage(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        return responseData;
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseData<Object> handleAuthenticationException(AuthenticationException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [Authentication] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [Authentication] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.UNAUTHORIZED.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.UNAUTHORIZED.getName());
        return responseData;
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    public ResponseData<Object> handleUnauthenticatedException(UnauthenticatedException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [Unauthenticated] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [Unauthenticated] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.UNAUTHENTICATED.getValue());
        responseData.setMessage(ResponseStateEnum.UNAUTHENTICATED.getName());
        return responseData;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ResponseData<Object> handleUnauthorizedException(UnauthorizedException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [Unauthorized] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [Unauthorized] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.FORBIDDEN.getValue());
        responseData.setMessage(ResponseStateEnum.FORBIDDEN.getName());
        return responseData;
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ResponseData<Object> handleAuthorizationException(AuthorizationException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[Shiro] [Authorization] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[Shiro] [Authorization] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.FORBIDDEN.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.FORBIDDEN.getName());
        return responseData;
    }
}

