/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.shiro.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.ConcurrentAccessException;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ShiroExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroExceptionHandler.class);

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseData<Object> handleAuthenticationException(AuthenticationException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.UNAUTHORIZED.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.UNAUTHORIZED.getName());
        return responseData;
    }

    @ExceptionHandler(value={ConcurrentAccessException.class})
    public ResponseData<Object> handleConcurrentAccessException(ConcurrentAccessException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.CONCURRENT_LOGIN.getValue());
        responseData.setMessage(ResponseStateEnum.CONCURRENT_LOGIN.getName());
        return responseData;
    }

    @ExceptionHandler(value={CredentialsException.class})
    public ResponseData<Object> handleCredentialsException(CredentialsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.ACCOUNT_EXPIRED.getValue());
        responseData.setMessage(ResponseStateEnum.ACCOUNT_EXPIRED.getName());
        return responseData;
    }

    @ExceptionHandler(value={ExpiredCredentialsException.class})
    public ResponseData<Object> handleExpiredCredentialsException(ExpiredCredentialsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue());
        responseData.setMessage(ResponseStateEnum.CREDENTIALS_EXPIRED.getName());
        return responseData;
    }

    @ExceptionHandler(value={IncorrectCredentialsException.class})
    public ResponseData<Object> handleIncorrectCredentialsException(IncorrectCredentialsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue());
        responseData.setMessage(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        return responseData;
    }

    @ExceptionHandler(value={DisabledAccountException.class})
    public ResponseData<Object> handleDisabledAccountException(DisabledAccountException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.ACCOUNT_DISABLED.getValue());
        responseData.setMessage(ResponseStateEnum.ACCOUNT_DISABLED.getName());
        return responseData;
    }

    @ExceptionHandler(value={LockedAccountException.class})
    public ResponseData<Object> handleLockedAccountException(LockedAccountException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.ACCOUNT_LOCKED.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.ACCOUNT_LOCKED.getName());
        return responseData;
    }

    @ExceptionHandler(value={ExcessiveAttemptsException.class})
    public ResponseData<Object> handleExcessiveAttemptsException(ExcessiveAttemptsException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.EXCESSIVE_ATTEMPTS.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.EXCESSIVE_ATTEMPTS.getName());
        return responseData;
    }

    @ExceptionHandler(value={UnknownAccountException.class})
    public ResponseData<Object> handleUnknownAccountException(UnknownAccountException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue());
        responseData.setMessage(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        return responseData;
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ResponseData<Object> handleAuthorizationException(AuthorizationException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.FORBIDDEN.getValue());
        responseData.setMessage(Objects.nonNull(e.getMessage()) ? e.getMessage() : ResponseStateEnum.FORBIDDEN.getName());
        return responseData;
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    public ResponseData<Object> handleUnauthenticatedException(UnauthenticatedException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.UNAUTHENTICATED.getValue());
        responseData.setMessage(ResponseStateEnum.UNAUTHENTICATED.getName());
        return responseData;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ResponseData<Object> handleUnauthorizedException(UnauthorizedException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.FORBIDDEN.getValue());
        responseData.setMessage(ResponseStateEnum.FORBIDDEN.getName());
        return responseData;
    }
}

