/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.shardingsphere.encrypt;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmarthseSm4EncryptAlgorithm
implements EncryptAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmarthseSm4EncryptAlgorithm.class);
    private static final String VERSION = "version";
    private static final String PASSWORD = "password";
    private final EncryptAlgorithmMetaData metaData = new EncryptAlgorithmMetaData(true, true, false);
    private Properties props;

    public Object encrypt(Object o, AlgorithmSQLContext algorithmSQLContext) {
        if (o == null) {
            return null;
        }
        String value = Convert.toStr((Object)o);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6\uff01\uff01\uff01");
            return value;
        }
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        if (data.length > 1023) {
            throw new IllegalArgumentException("Input data is too long");
        }
        try {
            return this.props.getProperty(VERSION) + EncryptUtils.encryptBySm4((String)value, (String)this.props.getProperty(PASSWORD));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public Object decrypt(Object o, AlgorithmSQLContext algorithmSQLContext) {
        if (o == null) {
            return null;
        }
        try {
            String value = Convert.toStr((Object)o);
            if (StrUtil.isBlank((CharSequence)value)) {
                return null;
            }
            if (value.length() <= 14 || !StrUtil.startWith((CharSequence)value, (CharSequence)"VI*D#S")) {
                return value;
            }
            value = StrUtil.subSuf((CharSequence)value, (int)14);
            return EncryptUtils.decryptBySm4((String)value, (String)this.props.getProperty(PASSWORD));
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public EncryptAlgorithmMetaData getMetaData() {
        return this.metaData;
    }

    public AlgorithmConfiguration toConfiguration() {
        return new AlgorithmConfiguration(this.getType(), this.props);
    }

    public String getType() {
        return "SMARTHSE_SM4";
    }

    public void init(Properties props) {
        this.props = props;
        if (props != null) {
            String version = props.getProperty(VERSION, props.getProperty(VERSION));
            String password = props.getProperty(PASSWORD, props.getProperty(PASSWORD));
            if (StringUtils.isEmpty((String)version) || StringUtils.isEmpty((String)password)) {
                throw new IllegalArgumentException("\u7248\u672c\u53f7\u6216\u79d8\u94a5\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new IllegalArgumentException("\u521d\u59cb\u5316\u53c2\u6570props\u4e0d\u80fd\u4e3anull");
        }
    }
}

