/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.shardingsphere.encrypt;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.utils.EncryptUtils;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmarthseWcspLightDataServiceEncryptAlgorithm
implements EncryptAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmarthseWcspLightDataServiceEncryptAlgorithm.class);
    private final EncryptAlgorithmMetaData metaData = new EncryptAlgorithmMetaData(true, true, false);
    private Properties props;

    public Object encrypt(Object o, AlgorithmSQLContext algorithmSQLContext) {
        if (o == null) {
            return null;
        }
        String value = Convert.toStr((Object)o);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6\uff01\uff01\uff01");
            return value;
        }
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        if (data.length > 1023) {
            throw new IllegalArgumentException("Input data is too long");
        }
        try {
            return EncryptUtils.getWcspVersion() + EncryptUtils.encryptByWcspLightDataService((String)value);
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public Object decrypt(Object o, AlgorithmSQLContext algorithmSQLContext) {
        if (o == null) {
            return null;
        }
        try {
            String value = Convert.toStr((Object)o);
            if (StrUtil.isBlank((CharSequence)value)) {
                return null;
            }
            if (value.length() <= 14 || !StrUtil.startWith((CharSequence)value, (CharSequence)"VI*D#S")) {
                return value;
            }
            value = StrUtil.subSuf((CharSequence)value, (int)14);
            return EncryptUtils.decryptByWcspLightDataService((String)value);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public EncryptAlgorithmMetaData getMetaData() {
        return this.metaData;
    }

    public AlgorithmConfiguration toConfiguration() {
        return new AlgorithmConfiguration(this.getType(), this.props);
    }

    public String getType() {
        return "SMARTHSE_WCSP_LIGHT_DATA_SERVICE";
    }

    public void init(Properties props) {
        this.props = props;
    }
}

