/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.shardingsphere.config;

import cn.smarthse.core.wcsp.context.WcspContext;
import cn.smarthse.core.wcsp.pool.WcspServicePlatformPool;
import cn.smarthse.core.wcsp.utils.WcspEncryptionUtils;
import cn.smarthse.framework.shardingsphere.config.properties.FieldEncryptorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={FieldEncryptorProperties.class})
public class FieldEncryptorAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptorAutoConfig.class);
    private final FieldEncryptorProperties fieldEncryptionProperties;

    @Bean(destroyMethod="close")
    @ConditionalOnProperty(value={"mybatis-encryptor.algorithm"}, havingValue="WCSP_LIGHT_DATA_SERVICE")
    public WcspServicePlatformPool cryptoServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptionUtils \u914d\u7f6e");
        WcspContext wcspContext = new WcspContext();
        wcspContext.setWcspUrl(this.fieldEncryptionProperties.getWcspUrl());
        wcspContext.setWcspTenantId(this.fieldEncryptionProperties.getWcspTenantId());
        wcspContext.setWcspAppId(this.fieldEncryptionProperties.getWcspAppId());
        wcspContext.setWcspSecret(this.fieldEncryptionProperties.getWcspSecret());
        wcspContext.setWcspWorkDir(this.fieldEncryptionProperties.getWcspWorkDir());
        wcspContext.setWcspPoolMaxTotal(this.fieldEncryptionProperties.getWcspPoolMaxTotal());
        wcspContext.setWcspPoolMaxIdle(this.fieldEncryptionProperties.getWcspPoolMaxIdle());
        wcspContext.setWcspPoolMinIdle(this.fieldEncryptionProperties.getWcspPoolMinIdle());
        wcspContext.setWcspPoolMaxWaitMillis(this.fieldEncryptionProperties.getWcspPoolMaxWaitMillis());
        wcspContext.setWcspAlias(this.fieldEncryptionProperties.getWcspAlias());
        wcspContext.setWcspDescription(this.fieldEncryptionProperties.getWcspDescription());
        wcspContext.setWcspVersion(this.fieldEncryptionProperties.getWcspVersion());
        WcspServicePlatformPool pool = new WcspServicePlatformPool(wcspContext);
        WcspEncryptionUtils.initialize((WcspServicePlatformPool)pool);
        return pool;
    }

    @Generated
    public FieldEncryptorAutoConfig(FieldEncryptorProperties fieldEncryptionProperties) {
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }
}

