/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.sensitive.filter;

import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.sensitive.config.properties.SensitiveProperties;
import cn.smarthse.framework.sensitive.handle.DesensitizationHandle;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

public class SensitiveFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        try {
            SensitiveProperties properties = (SensitiveProperties)SpringUtils.getBean(SensitiveProperties.class);
            if (Boolean.TRUE.equals(properties.getFrontEndControl())) {
                String s = servletRequest.getHeader("X-Desensitize");
                DesensitizationHandle.setEnabled(StringUtils.isBlank((CharSequence)s) || "true".equalsIgnoreCase(s));
            } else {
                DesensitizationHandle.setEnabled(true);
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            throw new RuntimeException("desensitization error", e);
        }
        finally {
            DesensitizationHandle.clearEnabled();
        }
    }

    public void destroy() {
    }
}

