/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.sensitive.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesensitizationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DesensitizationUtils.class);

    public static boolean isDesensitizationField(String cs, String search) {
        if (StringUtils.isBlank((CharSequence)cs)) {
            return false;
        }
        return StringUtils.containsAnyIgnoreCase((CharSequence)cs, (CharSequence[])new CharSequence[]{search});
    }

    public static boolean isDesensitizationField(String cs) {
        return DesensitizationUtils.isDesensitizationField(cs, "*");
    }

    public static String ignoreSetDesensitizationField(String cs, String search) {
        if (StringUtils.isBlank((CharSequence)cs)) {
            return null;
        }
        if (DesensitizationUtils.isDesensitizationField(cs, search)) {
            return null;
        }
        return cs;
    }

    public static String ignoreSetDesensitizationField(String cs) {
        return DesensitizationUtils.ignoreSetDesensitizationField(cs, "*");
    }

    public static boolean isChinese(CharSequence str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u4e00' && c <= '\u9fa5') continue;
            return false;
        }
        return true;
    }

    public static String englishName(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return name;
        }
        CharSequence[] words = StrUtil.split((CharSequence)name, (char)' ').toArray(new String[0]);
        for (int i = 0; i < words.length; ++i) {
            words[i] = DesensitizationUtils.processWord((String)words[i]);
        }
        return String.join((CharSequence)" ", words);
    }

    public static String processWord(String word) {
        if (StrUtil.isBlank((CharSequence)word)) {
            return word;
        }
        int length = word.length();
        return switch (length) {
            case 1 -> word;
            case 2 -> StrUtil.hide((CharSequence)word, (int)0, (int)1);
            case 3 -> StrUtil.hide((CharSequence)word, (int)1, (int)2);
            default -> word.charAt(0) + "**" + word.charAt(length - 1);
        };
    }

    public static String name(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return name;
        }
        return DesensitizationUtils.isChinese(name) ? DesensitizationUtils.processWord(name) : DesensitizationUtils.englishName(name);
    }

    public static String desensitized(CharSequence str, int start, int end, String symbol) {
        return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)start, (int)end, (CharSequence)symbol);
    }

    public static String desensitized(CharSequence str, DesensitizationType desensitizedType) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return "";
        }
        return switch (desensitizedType) {
            case DesensitizationType.USER_ID -> Convert.toStr((Object)DesensitizedUtil.userId());
            case DesensitizationType.NAME -> DesensitizationUtils.name(Convert.toStr((Object)str));
            case DesensitizationType.ID_CARD -> DesensitizedUtil.idCardNum((String)Convert.toStr((Object)str), (int)1, (int)2);
            case DesensitizationType.FIXED_PHONE -> DesensitizedUtil.fixedPhone((String)Convert.toStr((Object)str));
            case DesensitizationType.MOBILE_PHONE -> DesensitizedUtil.mobilePhone((String)Convert.toStr((Object)str));
            case DesensitizationType.ADDRESS -> DesensitizedUtil.address((String)Convert.toStr((Object)str), (int)8);
            case DesensitizationType.EMAIL -> DesensitizedUtil.email((String)Convert.toStr((Object)str));
            case DesensitizationType.PASSWORD -> DesensitizedUtil.password((String)Convert.toStr((Object)str));
            case DesensitizationType.CAR_LICENSE -> DesensitizedUtil.carLicense((String)Convert.toStr((Object)str));
            case DesensitizationType.BANK_CARD -> DesensitizedUtil.bankCard((String)Convert.toStr((Object)str));
            case DesensitizationType.IPV4 -> DesensitizedUtil.ipv4((String)Convert.toStr((Object)str));
            case DesensitizationType.IPV6 -> DesensitizedUtil.ipv6((String)Convert.toStr((Object)str));
            case DesensitizationType.FIRST_MASK -> DesensitizedUtil.firstMask((String)Convert.toStr((Object)str));
            case DesensitizationType.CLEAR_TO_EMPTY -> DesensitizedUtil.clear();
            case DesensitizationType.CLEAR_TO_NULL -> DesensitizedUtil.clearToNull();
            default -> throw new IllegalArgumentException("unknown sensitive type enum " + String.valueOf((Object)desensitizedType));
        };
    }

    public static Set<Field> getDesensitizationFieldSetFromClazz(Class<?> clazz) {
        HashSet<Field> fieldSet = new HashSet<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Desensitization.class)) continue;
                field.setAccessible(true);
                fieldSet.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldSet;
    }

    public static <T> T setDesensitizationFieldFromObject(T obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        Set<Field> desensitizationFields = DesensitizationUtils.getDesensitizationFieldSetFromClazz(obj.getClass());
        for (Field field : desensitizationFields) {
            try {
                Object value = field.get(obj);
                if (!(value instanceof String)) continue;
                Desensitization annotation = field.getAnnotation(Desensitization.class);
                String desensitizedValue = annotation.type() == DesensitizationType.CUSTOM_ROLE ? DesensitizationUtils.desensitized((String)value, annotation.start(), annotation.end(), annotation.symbol()) : DesensitizationUtils.desensitized((String)value, annotation.type());
                log.debug("desensitize field {} from {} to {}", new Object[]{field.getName(), value, desensitizedValue});
                field.set(obj, desensitizedValue);
            }
            catch (IllegalAccessException e) {
                log.error("desensitize object fields error", (Throwable)e);
            }
        }
        return obj;
    }

    @Generated
    private DesensitizationUtils() {
    }
}

