/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.sensitive.handle;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;

public class DesensitizationHandle
extends JsonSerializer<String>
implements ContextualSerializer {
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal();
    private DesensitizationType type;
    private Integer start;
    private Integer end;
    private String symbol;

    private DesensitizationHandle() {
    }

    public DesensitizationHandle(DesensitizationType type, int start, int end, String symbol) {
        this.type = type;
        this.start = start;
        this.end = end;
        this.symbol = symbol;
    }

    public static void setEnabled(boolean enabled) {
        ENABLED.set(enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void clearEnabled() {
        ENABLED.remove();
    }

    public void serialize(String str, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        block19: {
            block18: {
                if (!Boolean.TRUE.equals(ENABLED.get())) break block18;
                switch (this.type) {
                    case CUSTOM_ROLE: {
                        gen.writeString(DesensitizationUtils.desensitized(str, this.start, this.end, this.symbol));
                        break block19;
                    }
                    case USER_ID: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.USER_ID));
                        break block19;
                    }
                    case NAME: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.NAME));
                        break block19;
                    }
                    case ID_CARD: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.ID_CARD));
                        break block19;
                    }
                    case FIXED_PHONE: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.FIXED_PHONE));
                        break block19;
                    }
                    case MOBILE_PHONE: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.MOBILE_PHONE));
                        break block19;
                    }
                    case ADDRESS: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.ADDRESS));
                        break block19;
                    }
                    case EMAIL: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.EMAIL));
                        break block19;
                    }
                    case PASSWORD: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.PASSWORD));
                        break block19;
                    }
                    case CAR_LICENSE: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.CAR_LICENSE));
                        break block19;
                    }
                    case BANK_CARD: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.BANK_CARD));
                        break block19;
                    }
                    case IPV4: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.IPV4));
                        break block19;
                    }
                    case IPV6: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.IPV6));
                        break block19;
                    }
                    case FIRST_MASK: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.FIRST_MASK));
                        break block19;
                    }
                    case CLEAR_TO_EMPTY: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.CLEAR_TO_EMPTY));
                        break block19;
                    }
                    case CLEAR_TO_NULL: {
                        gen.writeString(DesensitizationUtils.desensitized(str, DesensitizationType.CLEAR_TO_NULL));
                        break block19;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown sensitive type enum " + String.valueOf((Object)this.type));
                    }
                }
            }
            gen.writeString(str);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty == null) {
            return prov.findNullValueSerializer(null);
        }
        if (!beanProperty.getType().getRawClass().equals(String.class)) {
            return prov.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        Desensitization desensitization = (Desensitization)beanProperty.getAnnotation(Desensitization.class);
        if (desensitization == null) {
            return prov.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return new DesensitizationHandle(desensitization.type(), desensitization.start(), desensitization.end(), desensitization.symbol());
    }
}

