/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.satoken.handler;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.hutool.core.convert.Convert;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=0x7FFFFFFE)
@RestControllerAdvice
public class SaTokenExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaTokenExceptionHandler.class);

    @ExceptionHandler(value={NotPermissionException.class})
    public ResponseData<Object> handleNotPermissionException(NotPermissionException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[SaToken] [NotPermission] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[SaToken] [NotPermission] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.FORBIDDEN.getValue());
        responseData.setMessage(ResponseStateEnum.FORBIDDEN.getName());
        return responseData;
    }

    @ExceptionHandler(value={NotRoleException.class})
    public ResponseData<Object> handleNotRoleException(NotRoleException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[SaToken] [NotRole] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[SaToken] [NotRole] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.FORBIDDEN.getValue());
        responseData.setMessage(ResponseStateEnum.FORBIDDEN.getName());
        return responseData;
    }

    @ExceptionHandler(value={NotLoginException.class})
    public ResponseData<Object> handleNotLoginException(NotLoginException e, HttpServletRequest request) {
        if (Objects.isNull(request)) {
            log.warn("[SaToken] [NotLogin] [failure] [warn] [non-web] exceptionClass={} message={}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
        log.warn("[SaToken] [NotLogin] [failure] [warn] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage()});
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.UNAUTHORIZED.getValue());
        String code = Convert.toStr((Object)e.getType());
        if ("-1".equals(code)) {
            responseData.setMessage(ResponseStateEnum.UNAUTHENTICATED.getName());
        } else if ("-2".equals(code)) {
            responseData.setMessage(ResponseStateEnum.INVALID_TOKEN.getName());
        } else if ("-3".equals(code)) {
            responseData.setMessage(ResponseStateEnum.TOKEN_EXPIRED.getName());
        } else if ("-4".equals(code)) {
            responseData.setMessage(ResponseStateEnum.CONCURRENT_LOGIN.getName());
        } else if ("-5".equals(code)) {
            responseData.setMessage(ResponseStateEnum.CONCURRENT_LOGIN.getName());
        } else if ("-6".equals(code)) {
            responseData.setMessage(ResponseStateEnum.ACCOUNT_EXPIRED.getName());
        } else if ("-7".equals(code)) {
            responseData.setMessage(ResponseStateEnum.UNAUTHORIZED.getName());
        } else {
            responseData.setMessage(ResponseStateEnum.UNAUTHORIZED.getName());
        }
        return responseData;
    }
}

