/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.satoken.core.dao;

import cn.dev33.satoken.dao.auto.SaTokenDaoBySessionFollowObject;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.smarthse.framework.redis.utils.RedisUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PlusSaTokenDao
implements SaTokenDaoBySessionFollowObject {
    private static final Cache<String, Object> CAFFEINE = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).initialCapacity(100).maximumSize(1000L).build();

    public String get(String key) {
        Object o = CAFFEINE.get((Object)key, k -> RedisUtils.getCacheObject((String)key));
        return (String)o;
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RedisUtils.setCacheObject((String)key, (Object)value);
        } else {
            RedisUtils.setCacheObject((String)key, (Object)value, (Duration)Duration.ofSeconds(timeout));
        }
        CAFFEINE.invalidate((Object)key);
    }

    public void update(String key, String value) {
        if (RedisUtils.hasKey((String)key).booleanValue()) {
            RedisUtils.setCacheObject((String)key, (Object)value, (boolean)true);
            CAFFEINE.invalidate((Object)key);
        }
    }

    public void delete(String key) {
        if (RedisUtils.deleteObject((String)key)) {
            CAFFEINE.invalidate((Object)key);
        }
    }

    public long getTimeout(String key) {
        long timeout = RedisUtils.getTimeToLive((String)key);
        return timeout < 0L ? timeout : timeout / 1000L + 1L;
    }

    public void updateTimeout(String key, long timeout) {
        RedisUtils.expire((String)key, (Duration)Duration.ofSeconds(timeout));
    }

    public Object getObject(String key) {
        Object o = CAFFEINE.get((Object)key, k -> RedisUtils.getCacheObject((String)key));
        return o;
    }

    public <T> T getObject(String key, Class<T> classType) {
        Object o = CAFFEINE.get((Object)key, k -> RedisUtils.getCacheObject((String)key));
        return (T)o;
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RedisUtils.setCacheObject((String)key, (Object)object);
        } else {
            RedisUtils.setCacheObject((String)key, (Object)object, (Duration)Duration.ofSeconds(timeout));
        }
        CAFFEINE.invalidate((Object)key);
    }

    public void updateObject(String key, Object object) {
        if (RedisUtils.hasKey((String)key).booleanValue()) {
            RedisUtils.setCacheObject((String)key, (Object)object, (boolean)true);
            CAFFEINE.invalidate((Object)key);
        }
    }

    public void deleteObject(String key) {
        if (RedisUtils.deleteObject((String)key)) {
            CAFFEINE.invalidate((Object)key);
        }
    }

    public long getObjectTimeout(String key) {
        long timeout = RedisUtils.getTimeToLive((String)key);
        return timeout < 0L ? timeout : timeout / 1000L + 1L;
    }

    public void updateObjectTimeout(String key, long timeout) {
        RedisUtils.expire((String)key, (Duration)Duration.ofSeconds(timeout));
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        String keyStr = prefix + "*" + keyword + "*";
        return (List)CAFFEINE.get((Object)keyStr, k -> {
            Collection keys = RedisUtils.keys((String)keyStr);
            ArrayList list = new ArrayList(keys);
            return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
        });
    }
}

