/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.redis.utils;

import cn.smarthse.framework.core.utils.SpringUtils;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RPriorityBlockingQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;

public class QueueUtils {
    private static final RedissonClient CLIENT = (RedissonClient)SpringUtils.getBean(RedissonClient.class);

    public static RedissonClient getClient() {
        return CLIENT;
    }

    public static <T> boolean addQueueObject(String queueName, T data) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        return queue.offer(data);
    }

    public static <T> T getQueueObject(String queueName) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        return (T)queue.poll();
    }

    public static <T> boolean removeQueueObject(String queueName, T data) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        return queue.remove(data);
    }

    public static <T> boolean destroyQueue(String queueName) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        return queue.delete();
    }

    public static <T> void addDelayedQueueObject(String queueName, T data, long time) {
        QueueUtils.addDelayedQueueObject(queueName, data, time, TimeUnit.MILLISECONDS);
    }

    public static <T> void addDelayedQueueObject(String queueName, T data, long time, TimeUnit timeUnit) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        RDelayedQueue delayedQueue = CLIENT.getDelayedQueue((RQueue)queue);
        delayedQueue.offer(data, time, timeUnit);
    }

    public static <T> T getDelayedQueueObject(String queueName) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        RDelayedQueue delayedQueue = CLIENT.getDelayedQueue((RQueue)queue);
        return (T)delayedQueue.poll();
    }

    public static <T> boolean removeDelayedQueueObject(String queueName, T data) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        RDelayedQueue delayedQueue = CLIENT.getDelayedQueue((RQueue)queue);
        return delayedQueue.remove(data);
    }

    public static <T> void destroyDelayedQueue(String queueName) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        RDelayedQueue delayedQueue = CLIENT.getDelayedQueue((RQueue)queue);
        delayedQueue.destroy();
    }

    public static <T> boolean addPriorityQueueObject(String queueName, T data) {
        RPriorityBlockingQueue priorityBlockingQueue = CLIENT.getPriorityBlockingQueue(queueName);
        return priorityBlockingQueue.offer(data);
    }

    public static <T> T getPriorityQueueObject(String queueName) {
        RPriorityBlockingQueue queue = CLIENT.getPriorityBlockingQueue(queueName);
        return (T)queue.poll();
    }

    public static <T> boolean removePriorityQueueObject(String queueName, T data) {
        RPriorityBlockingQueue queue = CLIENT.getPriorityBlockingQueue(queueName);
        return queue.remove(data);
    }

    public static <T> boolean destroyPriorityQueue(String queueName) {
        RPriorityBlockingQueue queue = CLIENT.getPriorityBlockingQueue(queueName);
        return queue.delete();
    }

    public static <T> boolean trySetBoundedQueueCapacity(String queueName, int capacity) {
        RBoundedBlockingQueue boundedBlockingQueue = CLIENT.getBoundedBlockingQueue(queueName);
        return boundedBlockingQueue.trySetCapacity(capacity);
    }

    public static <T> boolean trySetBoundedQueueCapacity(String queueName, int capacity, boolean destroy) {
        RBoundedBlockingQueue boundedBlockingQueue = CLIENT.getBoundedBlockingQueue(queueName);
        if (destroy) {
            boundedBlockingQueue.delete();
        }
        return boundedBlockingQueue.trySetCapacity(capacity);
    }

    public static <T> boolean addBoundedQueueObject(String queueName, T data) {
        RBoundedBlockingQueue boundedBlockingQueue = CLIENT.getBoundedBlockingQueue(queueName);
        return boundedBlockingQueue.offer(data);
    }

    public static <T> T getBoundedQueueObject(String queueName) {
        RBoundedBlockingQueue queue = CLIENT.getBoundedBlockingQueue(queueName);
        return (T)queue.poll();
    }

    public static <T> boolean removeBoundedQueueObject(String queueName, T data) {
        RBoundedBlockingQueue queue = CLIENT.getBoundedBlockingQueue(queueName);
        return queue.remove(data);
    }

    public static <T> boolean destroyBoundedQueue(String queueName) {
        RBoundedBlockingQueue queue = CLIENT.getBoundedBlockingQueue(queueName);
        return queue.delete();
    }

    public static <T> void subscribeBlockingQueue(String queueName, Function<T, CompletionStage<Void>> consumer, boolean isDelayed) {
        RBlockingQueue queue = CLIENT.getBlockingQueue(queueName);
        if (isDelayed) {
            CLIENT.getDelayedQueue((RQueue)queue);
        }
        queue.subscribeOnElements(consumer);
    }

    @Generated
    private QueueUtils() {
    }
}

