/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.redis.handler;

import cn.hutool.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class KeyPrefixRedisTemplateHandler
extends StringRedisSerializer {
    private final String keyPrefix;

    public KeyPrefixRedisTemplateHandler(String prefix) {
        super(StandardCharsets.UTF_8);
        this.keyPrefix = StrUtil.isBlank((CharSequence)prefix) ? "" : prefix + ":";
    }

    public byte[] serialize(String key) throws SerializationException {
        if (StrUtil.isBlank((CharSequence)key)) {
            return null;
        }
        return (this.keyPrefix + key).getBytes(StandardCharsets.UTF_8);
    }

    public String deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        String key = new String(bytes, StandardCharsets.UTF_8);
        return key.startsWith(this.keyPrefix) ? key.substring(this.keyPrefix.length()) : key;
    }
}

