/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.redis.utils;

import cn.hutool.extra.spring.SpringUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.redisson.api.ObjectListener;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RKeys;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.redisson.api.options.KeysScanOptions;

public class RedisUtils {
    private static final RedissonClient CLIENT = (RedissonClient)SpringUtil.getBean(RedissonClient.class);

    public static long rateLimiter(String key, RateType rateType, int rate, int rateInterval) {
        return RedisUtils.rateLimiter(key, rateType, rate, rateInterval, 0);
    }

    public static long rateLimiter(String key, RateType rateType, int rate, int rateInterval, int timeout) {
        RRateLimiter rateLimiter = CLIENT.getRateLimiter(key);
        rateLimiter.trySetRate(rateType, (long)rate, Duration.ofSeconds(rateInterval), Duration.ofSeconds(timeout));
        if (rateLimiter.tryAcquire()) {
            return rateLimiter.availablePermits();
        }
        return -1L;
    }

    public static RedissonClient getClient() {
        return CLIENT;
    }

    public static <T> void publish(String channelKey, T msg, Consumer<T> consumer) {
        RTopic topic = CLIENT.getTopic(channelKey);
        topic.publish(msg);
        consumer.accept(msg);
    }

    public static <T> void publish(String channelKey, T msg) {
        RTopic topic = CLIENT.getTopic(channelKey);
        topic.publish(msg);
    }

    public static <T> void subscribe(String channelKey, Class<T> clazz, Consumer<T> consumer) {
        RTopic topic = CLIENT.getTopic(channelKey);
        topic.addListener(clazz, (channel, msg) -> consumer.accept(msg));
    }

    public static <T> void setCacheObject(String key, T value) {
        RedisUtils.setCacheObject(key, value, false);
    }

    public static <T> void setCacheObject(String key, T value, boolean isSaveTtl) {
        block5: {
            RBucket bucket = CLIENT.getBucket(key);
            if (isSaveTtl) {
                try {
                    bucket.setAndKeepTTL(value);
                }
                catch (Exception e) {
                    long timeToLive = bucket.remainTimeToLive();
                    if (timeToLive == -1L) {
                        RedisUtils.setCacheObject(key, value);
                        break block5;
                    }
                    RedisUtils.setCacheObject(key, value, Duration.ofMillis(timeToLive));
                }
            } else {
                bucket.set(value);
            }
        }
    }

    public static <T> void setCacheObject(String key, T value, Duration duration) {
        RBatch batch = CLIENT.createBatch();
        RBucketAsync bucket = batch.getBucket(key);
        bucket.setAsync(value);
        bucket.expireAsync(duration);
        batch.execute();
    }

    public static <T> boolean setObjectIfAbsent(String key, T value, Duration duration) {
        RBucket bucket = CLIENT.getBucket(key);
        return bucket.setIfAbsent(value, duration);
    }

    public static <T> boolean setObjectIfExists(String key, T value, Duration duration) {
        RBucket bucket = CLIENT.getBucket(key);
        return bucket.setIfExists(value, duration);
    }

    public static <T> void addObjectListener(String key, ObjectListener listener) {
        RBucket result = CLIENT.getBucket(key);
        result.addListener(listener);
    }

    public static boolean expire(String key, long timeout) {
        return RedisUtils.expire(key, Duration.ofSeconds(timeout));
    }

    public static boolean expire(String key, Duration duration) {
        RBucket rBucket = CLIENT.getBucket(key);
        return rBucket.expire(duration);
    }

    public static <T> T getCacheObject(String key) {
        RBucket rBucket = CLIENT.getBucket(key);
        return (T)rBucket.get();
    }

    public static <T> long getTimeToLive(String key) {
        RBucket rBucket = CLIENT.getBucket(key);
        return rBucket.remainTimeToLive();
    }

    public static boolean deleteObject(String key) {
        return CLIENT.getBucket(key).delete();
    }

    public static void deleteObject(Collection collection) {
        RBatch batch = CLIENT.createBatch();
        collection.forEach(t -> batch.getBucket(t.toString()).deleteAsync());
        batch.execute();
    }

    public static boolean isExistsObject(String key) {
        return CLIENT.getBucket(key).isExists();
    }

    public static <T> boolean setCacheList(String key, List<T> dataList) {
        RList rList = CLIENT.getList(key);
        return rList.addAll(dataList);
    }

    public static <T> boolean addCacheList(String key, T data) {
        RList rList = CLIENT.getList(key);
        return rList.add(data);
    }

    public static <T> void addListListener(String key, ObjectListener listener) {
        RList rList = CLIENT.getList(key);
        rList.addListener(listener);
    }

    public static <T> List<T> getCacheList(String key) {
        RList rList = CLIENT.getList(key);
        return rList.readAll();
    }

    public static <T> List<T> getCacheListRange(String key, int form, int to) {
        RList rList = CLIENT.getList(key);
        return rList.range(form, to);
    }

    public static <T> boolean setCacheSet(String key, Set<T> dataSet) {
        RSet rSet = CLIENT.getSet(key);
        return rSet.addAll(dataSet);
    }

    public static <T> boolean addCacheSet(String key, T data) {
        RSet rSet = CLIENT.getSet(key);
        return rSet.add(data);
    }

    public static <T> void addSetListener(String key, ObjectListener listener) {
        RSet rSet = CLIENT.getSet(key);
        rSet.addListener(listener);
    }

    public static <T> Set<T> getCacheSet(String key) {
        RSet rSet = CLIENT.getSet(key);
        return rSet.readAll();
    }

    public static <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            RMap rMap = CLIENT.getMap(key);
            rMap.putAll(dataMap);
        }
    }

    public static <T> void addMapListener(String key, ObjectListener listener) {
        RMap rMap = CLIENT.getMap(key);
        rMap.addListener(listener);
    }

    public static <T> Map<String, T> getCacheMap(String key) {
        RMap rMap = CLIENT.getMap(key);
        return rMap.getAll(rMap.keySet());
    }

    public static <T> Set<String> getCacheMapKeySet(String key) {
        RMap rMap = CLIENT.getMap(key);
        return rMap.keySet();
    }

    public static <T> void setCacheMapValue(String key, String hKey, T value) {
        RMap rMap = CLIENT.getMap(key);
        rMap.put((Object)hKey, value);
    }

    public static <T> void setCacheMapValue(String key, String hKey, T value, Duration duration) {
        RMap rMap = CLIENT.getMap(key);
        rMap.expire(duration);
        rMap.put((Object)hKey, value);
    }

    public static <T> T getCacheMapValue(String key, String hKey) {
        RMap rMap = CLIENT.getMap(key);
        return (T)rMap.get((Object)hKey);
    }

    public static <T> T delCacheMapValue(String key, String hKey) {
        RMap rMap = CLIENT.getMap(key);
        return (T)rMap.remove((Object)hKey);
    }

    public static <T> void delMultiCacheMapValue(String key, Set<String> hKeys) {
        RBatch batch = CLIENT.createBatch();
        RMapAsync rMap = batch.getMap(key);
        for (String hKey : hKeys) {
            rMap.removeAsync((Object)hKey);
        }
        batch.execute();
    }

    public static <K, V> Map<K, V> getMultiCacheMapValue(String key, Set<K> hKeys) {
        RMap rMap = CLIENT.getMap(key);
        return rMap.getAll(hKeys);
    }

    public static void setAtomicValue(String key, long value) {
        RAtomicLong atomic = CLIENT.getAtomicLong(key);
        atomic.set(value);
    }

    public static long getAtomicValue(String key) {
        RAtomicLong atomic = CLIENT.getAtomicLong(key);
        return atomic.get();
    }

    public static long incrAtomicValue(String key) {
        RAtomicLong atomic = CLIENT.getAtomicLong(key);
        return atomic.incrementAndGet();
    }

    public static long decrAtomicValue(String key) {
        RAtomicLong atomic = CLIENT.getAtomicLong(key);
        return atomic.decrementAndGet();
    }

    public static Collection<String> keys(String pattern) {
        return RedisUtils.keys(KeysScanOptions.defaults().pattern(pattern).chunkSize(1000));
    }

    public static Collection<String> keys(KeysScanOptions keysScanOptions) {
        Stream keysStream = CLIENT.getKeys().getKeysStream(keysScanOptions);
        return keysStream.collect(Collectors.toList());
    }

    public static void deleteKeys(String pattern) {
        CLIENT.getKeys().deleteByPattern(pattern);
    }

    public static Boolean hasKey(String key) {
        RKeys rKeys = CLIENT.getKeys();
        return rKeys.countExists(new String[]{key}) > 0L;
    }

    @Generated
    private RedisUtils() {
    }
}

