/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.redis.handler;

import cn.hutool.core.util.StrUtil;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class KeyPrefixRedisTemplateHandler
implements RedisSerializer<String> {
    private final RedisSerializer<String> delegate;
    private final byte[] prefix;

    public KeyPrefixRedisTemplateHandler(RedisSerializer<String> delegate, String prefix) {
        this.delegate = delegate;
        prefix = StrUtil.isBlank((CharSequence)prefix) ? "" : (String)prefix + ":";
        this.prefix = ((String)prefix).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] serialize(String s) throws SerializationException {
        byte[] serialized = this.delegate.serialize((Object)s);
        byte[] result = new byte[this.prefix.length + serialized.length];
        System.arraycopy(this.prefix, 0, result, 0, this.prefix.length);
        System.arraycopy(serialized, 0, result, this.prefix.length, serialized.length);
        return result;
    }

    public String deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes.length >= this.prefix.length) {
            byte[] content = new byte[bytes.length - this.prefix.length];
            System.arraycopy(bytes, this.prefix.length, content, 0, content.length);
            return (String)this.delegate.deserialize(content);
        }
        return null;
    }
}

