/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.oss.bean;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.framework.core.utils.SSRFLeakUtil;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.core.utils.file.FileContentTypeUtils;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssClientBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OssClientBean.class);
    private String local;
    private String domain;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private boolean asynch;
    private boolean publicread;
    private int exptime;
    private OSSClient client;
    private static final String m3u8_suffix = ".m3u8";
    private static final String FILE_NAME_POINT_STRING = ".";
    private final String OLD_OSS_URL = "https://hse-oss-file1.oss-cn-hangzhou.aliyuncs.com/";

    public String getEndpoint() {
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            return "https://" + this.domain;
        }
        return this.endpoint;
    }

    public String getUrl(String urlfile) {
        return this.getUrl(urlfile, null, this.exptime);
    }

    public String getUrl(String urlfile, int exptime) {
        return this.getUrl(urlfile, null, exptime);
    }

    public String getUrl(String urlfile, String filename, int exptime) {
        if (this.isAsynch()) {
            if (StringUtils.isEmpty((String)urlfile)) {
                return "";
            }
            if (urlfile.contains("https://hse-oss-file1.oss-cn-hangzhou.aliyuncs.com/")) {
                urlfile = urlfile.replace("https://hse-oss-file1.oss-cn-hangzhou.aliyuncs.com/", "");
            }
            if (urlfile.contains("/trainImages/")) {
                return urlfile;
            }
            urlfile = urlfile.split("\\?")[0];
            urlfile = urlfile.replace(String.format("https://%s.%s/", this.bucketName, this.domain), "");
            if (this.publicread) {
                StringBuilder url = new StringBuilder();
                url.append("https://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append(this.domain).append("/").append(urlfile);
                if (StringUtils.isNotEmpty((String)filename)) {
                    url.append("?response-content-disposition=attachment;filename=").append(filename);
                }
                return url.toString();
            }
            Date exp = DateUtils.addSeconds((Date)new Date(), (int)exptime);
            return this.generatePresignedUrl(this.bucketName, filename, urlfile, exp, HttpMethod.GET).toString();
        }
        return ServletUtils.getCtx() + "/" + urlfile;
    }

    private URL generatePresignedUrl(String bucketName, String attachmentFilename, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        if (attachmentFilename != null && attachmentFilename != "") {
            responseHeaders.setContentDisposition("attachment;filename=\"" + attachmentFilename + "\"");
            responseHeaders.setContentEncoding("utf-8");
        }
        request.setResponseHeaders(responseHeaders);
        if (key.endsWith(m3u8_suffix)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("x-oss-process", "hls/sign");
            request.setQueryParameter(param);
        }
        return this.getClient().generatePresignedUrl(request);
    }

    public String getUrlBybucket(String bucket, String urlfile) {
        if (StringUtils.isEmpty((String)urlfile) || StringUtils.isEmpty((String)bucket)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("https://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append(this.domain).append("/").append(urlfile);
            return url.toString();
        }
        Date exp = DateUtils.addSeconds((Date)new Date(), (int)this.exptime);
        URL url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String getThumbnail(String urlfile, String styleName) {
        if (StringUtils.isEmpty((String)urlfile)) {
            return "";
        }
        if (((String)urlfile).indexOf("http://") >= 0 || ((String)urlfile).indexOf("https://") >= 0) {
            return urlfile;
        }
        URL url = null;
        Date exp = DateUtils.addSeconds((Date)new Date(), (int)this.exptime);
        urlfile = (String)urlfile + "@!" + styleName;
        url = this.getClient().generatePresignedUrl(this.bucketName, (String)urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String OSSPutObject(File file, String ossUrl, String fileFullname) {
        return this.OSSPutObject(file, ossUrl, fileFullname, null, FileContentTypeUtils.contentType((String)fileFullname));
    }

    public String OSSPutObject(File file, String ossUrl, String fileFullname, String contentMD5, String contentType) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(file.length());
        objectMeta.setContentEncoding("UTF-8");
        if (StringUtils.isNotEmpty((String)fileFullname)) {
            try {
                fileFullname = URLEncoder.encode(fileFullname, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("UnsupportedEncodingException\uff1a", (Throwable)e);
            }
            objectMeta.setContentDisposition("inline;filename*=utf-8'zh_cn'" + fileFullname);
            objectMeta.setHeader("Content-disposition", (Object)("filename*=utf-8'zh_cn'" + fileFullname));
        }
        if (StringUtils.isNotEmpty((String)contentType)) {
            objectMeta.setContentType(contentType + ";charset=utf-8");
        }
        if (StringUtils.isNotEmpty((String)contentMD5)) {
            objectMeta.setContentMD5(contentMD5);
        }
        return this.OSSPutObject(file, ossUrl, objectMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String OSSPutObject(File file, String ossUrl, ObjectMetadata objectMeta) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            ossUrl = ossUrl.replace("\\", "/");
            PutObjectResult putObjectResult = this.getClient().putObject(this.bucketName, ossUrl, (InputStream)input, objectMeta);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException\uff1a", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                log.error("IOException\uff1a", (Throwable)e);
            }
        }
        return ossUrl;
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, null, FileContentTypeUtils.contentType((String)fileFullname));
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, null, FileContentTypeUtils.contentType((String)fileFullname));
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5, String contentType) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(file.length());
        if (StringUtils.isNotEmpty((String)fileFullname)) {
            try {
                fileFullname = URLEncoder.encode(fileFullname, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("UnsupportedEncodingException\uff1a", (Throwable)e);
            }
            objectMeta.setContentDisposition("inline;filename*=utf-8'zh_cn'" + fileFullname);
            objectMeta.setHeader("Content-disposition", (Object)("filename*=utf-8'zh_cn'" + fileFullname));
            objectMeta.setContentEncoding("UTF-8");
        }
        if (StringUtils.isNotEmpty((String)contentType)) {
            objectMeta.setContentType(contentType + ";charset=utf-8");
        }
        if (StringUtils.isNotEmpty((String)contentMD5)) {
            objectMeta.setContentMD5(contentMD5);
        }
        return this.OSSPutObject(serviceFilename, file, serviceDir, objectMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String OSSPutObject(String serviceFilename, File file, String serviceDir, ObjectMetadata objectMeta) {
        StringBuffer ossfile = new StringBuffer();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            serviceDir = serviceDir.replace("\\", "/");
            if (serviceDir.endsWith(serviceFilename)) {
                ossfile.append(serviceDir);
            } else if (serviceDir.endsWith("/")) {
                ossfile.append(serviceDir).append(serviceFilename);
            } else {
                ossfile.append(serviceDir).append("/").append(serviceFilename);
            }
            PutObjectResult putObjectResult = this.getClient().putObject(this.bucketName, ossfile.toString(), (InputStream)input, objectMeta);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException\uff1a", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                log.error("IOException\uff1a", (Throwable)e);
            }
        }
        return ossfile.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String OSSPutObject(String serviceFilename, InputStream input, String serviceDir, String contentType, long contentLength) {
        StringBuilder ossfile = new StringBuilder();
        try {
            serviceDir = serviceDir.replace("\\", "/");
            if (serviceDir.endsWith(serviceFilename)) {
                ossfile.append(serviceDir);
            } else if (serviceDir.endsWith("/")) {
                ossfile.append(serviceDir).append(serviceFilename);
            } else {
                ossfile.append(serviceDir).append("/").append(serviceFilename);
            }
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(contentType);
            objectMetadata.setContentLength(contentLength);
            this.getClient().putObject(this.bucketName, ossfile.toString(), input, objectMetadata);
            String string = ossfile.toString();
            return string;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20 OSS \u5931\u8d25\uff1a", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
        }
    }

    public String OSSPutObject(String key, String fileFullname, InputStream inputStream) throws IOException {
        String contentType;
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength((long)inputStream.available());
        objectMeta.setContentEncoding("UTF-8");
        if (StringUtils.isNotEmpty((String)fileFullname)) {
            fileFullname = URLEncoder.encode(fileFullname, StandardCharsets.UTF_8);
            objectMeta.setContentDisposition("inline;filename*=utf-8'zh_cn'" + fileFullname);
            objectMeta.setHeader("Content-disposition", (Object)("filename*=utf-8'zh_cn'" + fileFullname));
        }
        if (StringUtils.isNotEmpty((String)(contentType = FileContentTypeUtils.contentType((String)fileFullname)))) {
            objectMeta.setContentType(contentType + ";charset=utf-8");
        }
        objectMeta.setContentMD5(null);
        return this.OSSPutObject(key, inputStream, null);
    }

    public String OSSPutObject(String key, InputStream inputStream, ObjectMetadata objectMeta) {
        try {
            key = key.replace("\\", "/");
            PutObjectResult putObjectResult = this.getClient().putObject(this.bucketName, key, inputStream, objectMeta);
        }
        catch (OSSException e) {
            throw new RuntimeException(e);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("IOException\uff1a", (Throwable)e);
            }
        }
        return key;
    }

    public OSSObject downloadFile(String file) {
        OSSObject obj = null;
        try {
            obj = this.getClient().getObject(this.bucketName, file);
        }
        catch (OSSException oe) {
            log.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:{}", (Object)oe.getMessage());
        }
        catch (ClientException ce) {
            log.error("\u963f\u91cc\u4e91\u8fde\u63a5\u5931\u8d25:{}", (Object)ce.getMessage());
        }
        catch (NullPointerException n) {
            log.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:{}", (Object)n.getMessage());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String fileOssurl, String destFilePath, String fileName) throws IOException {
        OSSObject ossObject = this.downloadFile(fileOssurl);
        if (StringUtils.isEmpty((String)fileOssurl) || StringUtils.isEmpty((String)destFilePath) || ossObject == null || ossObject.getObjectContent() == null) {
            return fileName;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        String[] names = new String[]{fileName};
        File file = this.getNoRepeatDestFilePath(destFilePath, names);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            reader = ossObject.getObjectContent();
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = reader.read(b)) > 0) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (FileNotFoundException e) {
            log.error("\u6587\u4ef6\u672a\u627e\u5230:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:{}", (Object)e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return names[0];
    }

    public InputStream getInputStreamByUrl(String fileUrl) {
        try {
            if (StringUtils.isEmpty((String)fileUrl)) {
                return null;
            }
            if (!fileUrl.startsWith("http") && !fileUrl.startsWith("https")) {
                log.error("\u8be5\u8bf7\u6c42\u4e0d\u662f\u4ee5http\u6216https\u5f00\u5934");
                return null;
            }
            if (!SSRFLeakUtil.securitySSRFFileTypeCheck(null, (String)fileUrl)) {
                return null;
            }
            HttpResponse execute = HttpUtil.createGet((String)fileUrl).execute();
            InputStream reader = execute.bodyStream();
            return reader;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private File getNoRepeatDestFilePath(String destFilePath, String[] fileName) {
        if (!((String)destFilePath).endsWith(File.separator)) {
            destFilePath = (String)destFilePath + File.separator;
        }
        String fileSuffix = "";
        String pointStr = FILE_NAME_POINT_STRING;
        int pointIndex = fileName[0].lastIndexOf(FILE_NAME_POINT_STRING);
        if (pointIndex > 0) {
            fileSuffix = fileName[0].substring(pointIndex + 1);
            fileName[0] = fileName[0].substring(0, pointIndex);
        } else {
            pointStr = "";
        }
        File file = new File((String)destFilePath + fileName[0] + pointStr + fileSuffix);
        int i = 1;
        while (file.exists()) {
            file = new File((String)destFilePath + fileName[0] + i + pointStr + fileSuffix);
            ++i;
        }
        fileName[0] = i > 1 ? fileName[0] + --i + pointStr + fileSuffix : fileName[0] + pointStr + fileSuffix;
        return file;
    }

    public ObjectMetadata getObjectMetadataByUrl(String url) {
        return this.getClient().getObjectMetadata(this.bucketName, url);
    }

    public Map<String, String> getPostSignature(String dir) throws Exception {
        String host = "https://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
        long expireTime = 30L;
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        String postPolicy = this.getClient().generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.getClient().calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessid", this.accessKeyId);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", dir);
        respMap.put("host", host);
        respMap.put("expire", Convert.toStr((Object)(expireEndTime / 1000L)));
        JSONObject jasonCallback = new JSONObject();
        StringBuffer callbackBody = new StringBuffer("{");
        callbackBody.append("bucket:").append("${bucket}");
        callbackBody.append(",filename:").append("${object}");
        callbackBody.append(",etag:").append("${etag}");
        callbackBody.append(",size:").append("${size}");
        callbackBody.append(",mimeType:").append("${mimeType}");
        callbackBody.append(",height:").append("${imageInfo.height}");
        callbackBody.append(",width:").append("${imageInfo.width}");
        callbackBody.append(",format:").append("${imageInfo.format}");
        callbackBody.append("}");
        jasonCallback.put((Object)"callbackBody", (Object)callbackBody.toString());
        jasonCallback.put((Object)"callbackBodyType", (Object)"application/json");
        String base64CallbackBody = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
        respMap.put("callback", base64CallbackBody);
        return respMap;
    }

    public boolean VerifyOSSCallbackRequest(HttpServletRequest request, String ossCallbackBody) throws NumberFormatException, IOException {
        boolean ret = false;
        String autorizationInput = new String(request.getHeader("Authorization"));
        String pubKeyInput = request.getHeader("x-oss-pub-key-url");
        byte[] authorization = BinaryUtil.fromBase64String((String)autorizationInput);
        byte[] pubKey = BinaryUtil.fromBase64String((String)pubKeyInput);
        String pubKeyAddr = new String(pubKey);
        if (!pubKeyAddr.startsWith("http://gosspublic.alicdn.com/") && !pubKeyAddr.startsWith("https://gosspublic.alicdn.com/")) {
            System.out.println("pub key addr must be oss addrss");
            return false;
        }
        String retString = this.executeGet(pubKeyAddr);
        retString = retString.replace("-----BEGIN PUBLIC KEY-----", "");
        retString = retString.replace("-----END PUBLIC KEY-----", "");
        String queryString = request.getQueryString();
        String uri = request.getRequestURI();
        String decodeUri = URLDecoder.decode(uri, "UTF-8");
        Object authStr = decodeUri;
        if (queryString != null && !queryString.equals("")) {
            authStr = (String)authStr + "?" + queryString;
        }
        authStr = (String)authStr + "\n" + ossCallbackBody;
        ret = OssClientBean.doCheck((String)authStr, authorization, retString);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) {
        BufferedReader in = null;
        String content = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            content = sb.toString();
            return content;
        }
        catch (Exception e) {}
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error("Exception\uff1a", (Throwable)e);
                }
            }
            return content;
        }
    }

    public static boolean doCheck(String content, byte[] sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = BinaryUtil.fromBase64String((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes());
            boolean bverify = signature.verify(sign);
            return bverify;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return false;
        }
    }

    public String getHost() {
        return "https://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
    }

    public OSSClient getClient() {
        if (this.client == null) {
            ClientConfiguration configuration = new ClientConfiguration();
            configuration.setSupportCname(false);
            if (this.endpoint != null && this.endpoint.contains(Protocol.HTTPS.toString())) {
                configuration.setProtocol(Protocol.HTTPS);
            }
            this.client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret, configuration);
        }
        return this.client;
    }

    @Generated
    public OssClientBean() {
    }

    @Generated
    public String getLocal() {
        return this.local;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public boolean isAsynch() {
        return this.asynch;
    }

    @Generated
    public boolean isPublicread() {
        return this.publicread;
    }

    @Generated
    public int getExptime() {
        return this.exptime;
    }

    @Generated
    public String getOLD_OSS_URL() {
        return this.OLD_OSS_URL;
    }

    @Generated
    public void setLocal(String local) {
        this.local = local;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Generated
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    @Generated
    public void setPublicread(boolean publicread) {
        this.publicread = publicread;
    }

    @Generated
    public void setExptime(int exptime) {
        this.exptime = exptime;
    }

    @Generated
    public void setClient(OSSClient client) {
        this.client = client;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssClientBean)) {
            return false;
        }
        OssClientBean other = (OssClientBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsynch() != other.isAsynch()) {
            return false;
        }
        if (this.isPublicread() != other.isPublicread()) {
            return false;
        }
        if (this.getExptime() != other.getExptime()) {
            return false;
        }
        String this$local = this.getLocal();
        String other$local = other.getLocal();
        if (this$local == null ? other$local != null : !this$local.equals(other$local)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        OSSClient this$client = this.getClient();
        OSSClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$OLD_OSS_URL = this.getOLD_OSS_URL();
        String other$OLD_OSS_URL = other.getOLD_OSS_URL();
        return !(this$OLD_OSS_URL == null ? other$OLD_OSS_URL != null : !this$OLD_OSS_URL.equals(other$OLD_OSS_URL));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OssClientBean;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsynch() ? 79 : 97);
        result = result * 59 + (this.isPublicread() ? 79 : 97);
        result = result * 59 + this.getExptime();
        String $local = this.getLocal();
        result = result * 59 + ($local == null ? 43 : $local.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        OSSClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $OLD_OSS_URL = this.getOLD_OSS_URL();
        result = result * 59 + ($OLD_OSS_URL == null ? 43 : $OLD_OSS_URL.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OssClientBean(local=" + this.getLocal() + ", domain=" + this.getDomain() + ", endpoint=" + this.getEndpoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ", asynch=" + this.isAsynch() + ", publicread=" + this.isPublicread() + ", exptime=" + this.getExptime() + ", client=" + String.valueOf(this.getClient()) + ", OLD_OSS_URL=" + this.getOLD_OSS_URL() + ")";
    }
}

