/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.limit.aspectj;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.limit.enums.LimitType;
import cn.smarthse.framework.redis.core.RateLimiterResult;
import cn.smarthse.framework.redis.utils.RedisUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class RequestLimitAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLimitAspect.class);
    private final ExpressionParser parser = new SpelExpressionParser();

    @Before(value="@annotation(requestLimit)")
    public void logBefore(JoinPoint point, RequestLimit requestLimit) {
        int second = requestLimit.second();
        int maxCount = requestLimit.maxCount();
        int timeout = requestLimit.timeout();
        try {
            RateLimiterResult result;
            String key = this.invokeExpression(point, requestLimit.expression(), requestLimit.limitType());
            RateType rateType = RateType.OVERALL;
            if (requestLimit.limitType() == LimitType.CLUSTER) {
                rateType = RateType.PER_CLIENT;
            }
            if ((result = RedisUtils.rateLimiterWithNextAvailableTime((String)key, (RateType)rateType, (int)maxCount, (int)second, (int)timeout)).getAvailablePermits() == -1L) {
                throw new ServiceException(ResponseStateEnum.REQUEST_LIMIT.getValue(), StringUtils.isBlank((CharSequence)requestLimit.msg()) ? ResponseStateEnum.REQUEST_LIMIT.getName() : requestLimit.msg(), (Object)((double)result.getRemainingTime() / 1000.0));
            }
            if (log.isDebugEnabled()) {
                log.debug("\u9650\u5236\u4ee4\u724c => {}, \u5269\u4f59\u4ee4\u724c => {}, \u7f13\u5b58key => '{}'", new Object[]{maxCount, result.getAvailablePermits(), key});
            }
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw e;
            }
            throw new RuntimeException("\u670d\u52a1\u5668\u9650\u6d41\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", e);
        }
    }

    private String invokeExpression(JoinPoint point, String expression, LimitType limitType) {
        StringBuilder keyBuilder = new StringBuilder("request_limit:");
        keyBuilder.append(ServletUtils.getRequestUri((HttpServletRequest)ServletUtils.getRequest())).append(":");
        if (limitType == LimitType.IP) {
            keyBuilder.append(ServletUtils.getClientIP()).append(":");
        } else if (limitType == LimitType.CLUSTER) {
            keyBuilder.append(RedisUtils.getClient().getId()).append(":");
        }
        if (StringUtils.isNotBlank((CharSequence)expression) && StringUtils.containsAny((CharSequence)expression, (CharSequence)"#")) {
            Method method = RequestLimitAspect.getMethod(point);
            Object[] args = point.getArgs();
            StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
            Object[] parameterNames = discoverer.getParameterNames(method);
            StandardEvaluationContext context = new StandardEvaluationContext();
            if (ArrayUtil.isNotEmpty((Object[])parameterNames)) {
                for (int i = 0; i < parameterNames.length; ++i) {
                    context.setVariable((String)parameterNames[i], args[i]);
                }
            }
            Expression parsed = this.parser.parseExpression(expression);
            keyBuilder.append((String)parsed.getValue((EvaluationContext)context, String.class));
        } else {
            String methodName = point.getSignature().toString();
            String argsStr = RequestLimitAspect.joinMethodArgs(point);
            keyBuilder.append(SecureUtil.md5((String)(methodName + argsStr)));
        }
        return keyBuilder.toString();
    }

    private static Method getMethod(JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        if (!method.getDeclaringClass().isInterface()) {
            return method;
        }
        try {
            return point.getTarget().getClass().getDeclaredMethod(point.getSignature().getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static String joinMethodArgs(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        if (ArrayUtil.isEmpty((Object[])args)) {
            return "";
        }
        return ArrayUtil.join((Object[])args, (CharSequence)",", item -> {
            if (item == null) {
                return "";
            }
            String clazzName = item.getClass().getName();
            if (StrUtil.startWithAny((CharSequence)clazzName, (CharSequence[])new CharSequence[]{"javax.servlet", "jakarta.servlet", "org.springframework.web"})) {
                return "";
            }
            return item;
        });
    }
}

