/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.limit.aspectj;

import cn.hutool.core.convert.Convert;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.limit.enums.LimitType;
import cn.smarthse.framework.redis.utils.RedisUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class RequestLimitAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLimitAspect.class);
    private final ExpressionParser parser = new SpelExpressionParser();

    @Before(value="@annotation(requestLimit)")
    public void logBefore(JoinPoint point, RequestLimit requestLimit) {
        try {
            int timeout;
            String key = this.invokeExpression(point, requestLimit.expression(), requestLimit.limitType());
            RateType rateType = RateType.OVERALL;
            if (requestLimit.limitType() == LimitType.CLUSTER) {
                rateType = RateType.PER_CLIENT;
            }
            int second = requestLimit.second();
            int maxCount = requestLimit.maxCount();
            long number = RedisUtils.rateLimiter((String)key, (RateType)rateType, (int)maxCount, (int)second, (int)(timeout = requestLimit.timeout()));
            if (number == -1L) {
                throw new ServiceException(ResponseStateEnum.REQUEST_LIMIT.getValue(), StringUtils.isBlank((CharSequence)requestLimit.msg()) ? ResponseStateEnum.REQUEST_LIMIT.getName() : requestLimit.msg());
            }
            log.debug("\u9650\u5236\u4ee4\u724c => {}, \u5269\u4f59\u4ee4\u724c => {}, \u7f13\u5b58key => '{}'", new Object[]{maxCount, number, key});
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw e;
            }
            throw new RuntimeException("\u670d\u52a1\u5668\u9650\u6d41\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", e);
        }
    }

    private String invokeExpression(JoinPoint point, String expression, LimitType limitType) {
        StringBuilder keyBuilder = new StringBuilder("request_limit:");
        keyBuilder.append(ServletUtils.getRequest().getRequestURI()).append(":");
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method targetMethod = signature.getMethod();
        Object[] args = point.getArgs();
        if (StringUtils.isNotBlank((CharSequence)expression) && StringUtils.containsAny((CharSequence)expression, (CharSequence)"#")) {
            StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
            String[] parameterNames = discoverer.getParameterNames(targetMethod);
            StandardEvaluationContext context = new StandardEvaluationContext();
            if (Objects.nonNull(parameterNames)) {
                for (int i = 0; i < parameterNames.length; ++i) {
                    context.setVariable(parameterNames[i], args[i]);
                }
            }
            expression = (String)this.parser.parseExpression(expression).getValue((EvaluationContext)context, String.class);
        } else {
            String methodInfo = targetMethod.getDeclaringClass().getName() + targetMethod.getName() + (args != null ? Arrays.toString(args) : "[]");
            expression = Convert.toStr((Object)(methodInfo.hashCode() & Integer.MAX_VALUE));
        }
        if (limitType == LimitType.IP) {
            keyBuilder.append(ServletUtils.getClientIP()).append(":");
        } else if (limitType == LimitType.CLUSTER) {
            keyBuilder.append(RedisUtils.getClient().getId()).append(":");
        }
        return keyBuilder.append(expression).toString();
    }
}

