/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.json.config;

import cn.smarthse.framework.json.handler.DateDeserializer;
import cn.smarthse.framework.json.handler.LocalDateDeserializer;
import cn.smarthse.framework.json.handler.LocalDateSerializer;
import cn.smarthse.framework.json.handler.LocalDateTimeDeserializer;
import cn.smarthse.framework.json.handler.LocalDateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={JacksonAutoConfiguration.class})
public class JacksonAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonAutoConfig.class);

    @Bean
    public Module registerJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)LocalDateTimeSerializer.INSTANCE);
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)LocalDateTimeDeserializer.INSTANCE);
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)LocalDateSerializer.INSTANCE);
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)LocalDateDeserializer.INSTANCE);
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)DateDeserializer.INSTANCE);
        javaTimeModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        javaTimeModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        javaTimeModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        javaTimeModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        return javaTimeModule;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        log.info("\u521d\u59cb\u5316 jackson \u914d\u7f6e");
        return builder -> {
            builder.timeZone(TimeZone.getDefault());
            builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        };
    }
}

