/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.json.config;

import cn.smarthse.framework.json.handle.CustomDateDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={JacksonAutoConfiguration.class})
public class JacksonConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonConfig.class);
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        return builder -> {
            JavaTimeModule timeModule = new JavaTimeModule();
            timeModule.addSerializer((JsonSerializer)new LocalDateTimeSerializer(DATE_TIME_FORMATTER));
            timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATE_TIME_FORMATTER));
            timeModule.addSerializer((JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
            timeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
            timeModule.addSerializer((JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
            timeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
            timeModule.addDeserializer(Date.class, (JsonDeserializer)new CustomDateDeserializer());
            timeModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            timeModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            timeModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
            timeModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
            builder.modules(new Module[]{timeModule});
            builder.timeZone(TimeZone.getDefault());
            builder.serializationInclusion(JsonInclude.Include.NON_NULL);
            log.info("\u521d\u59cb\u5316 jackson \u914d\u7f6e");
        };
    }
}

