/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.utils;

import cn.idev.excel.ExcelWriter;
import cn.idev.excel.FastExcel;
import cn.idev.excel.context.WriteContext;
import cn.idev.excel.write.builder.ExcelWriterSheetBuilder;
import cn.idev.excel.write.builder.ExcelWriterTableBuilder;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.WriteTable;
import cn.idev.excel.write.metadata.fill.FillConfig;
import java.util.Collection;
import java.util.function.Supplier;

public record ExcelWriterWrapper<T>(ExcelWriter excelWriter) {
    public void write(Collection<T> data, WriteSheet writeSheet) {
        this.excelWriter.write(data, writeSheet);
    }

    public void write(Supplier<Collection<T>> supplier, WriteSheet writeSheet) {
        this.excelWriter.write(supplier.get(), writeSheet);
    }

    public void write(Collection<T> data, WriteSheet writeSheet, WriteTable writeTable) {
        this.excelWriter.write(data, writeSheet, writeTable);
    }

    public void write(Supplier<Collection<T>> supplier, WriteSheet writeSheet, WriteTable writeTable) {
        this.excelWriter.write(supplier.get(), writeSheet, writeTable);
    }

    public void fill(Object data, WriteSheet writeSheet) {
        this.excelWriter.fill(data, writeSheet);
    }

    public void fill(Object data, FillConfig fillConfig, WriteSheet writeSheet) {
        this.excelWriter.fill(data, fillConfig, writeSheet);
    }

    public void fill(Supplier<Object> supplier, WriteSheet writeSheet) {
        this.excelWriter.fill(supplier, writeSheet);
    }

    public void fill(Supplier<Object> supplier, FillConfig fillConfig, WriteSheet writeSheet) {
        this.excelWriter.fill(supplier, fillConfig, writeSheet);
    }

    public WriteContext writeContext() {
        return this.excelWriter.writeContext();
    }

    public static <T> ExcelWriterWrapper<T> of(ExcelWriter excelWriter) {
        return new ExcelWriterWrapper<T>(excelWriter);
    }

    public static WriteSheet buildSheet(Integer sheetNo, String sheetName) {
        return ExcelWriterWrapper.sheetBuilder(sheetNo, sheetName).build();
    }

    public static WriteSheet buildSheet(Integer sheetNo) {
        return ExcelWriterWrapper.sheetBuilder(sheetNo).build();
    }

    public static WriteSheet buildSheet(String sheetName) {
        return ExcelWriterWrapper.sheetBuilder(sheetName).build();
    }

    public static WriteSheet buildSheet() {
        return ExcelWriterWrapper.sheetBuilder().build();
    }

    public static ExcelWriterSheetBuilder sheetBuilder(Integer sheetNo, String sheetName) {
        return FastExcel.writerSheet((Integer)sheetNo, (String)sheetName);
    }

    public static ExcelWriterSheetBuilder sheetBuilder(Integer sheetNo) {
        return FastExcel.writerSheet((Integer)sheetNo);
    }

    public static ExcelWriterSheetBuilder sheetBuilder(String sheetName) {
        return FastExcel.writerSheet((String)sheetName);
    }

    public static ExcelWriterSheetBuilder sheetBuilder() {
        return FastExcel.writerSheet();
    }

    public static WriteTable buildTable(Integer tableNo) {
        return ExcelWriterWrapper.tableBuilder(tableNo).build();
    }

    public static WriteTable buildTable() {
        return ExcelWriterWrapper.tableBuilder().build();
    }

    public static ExcelWriterTableBuilder tableBuilder(Integer tableNo) {
        return FastExcel.writerTable((Integer)tableNo);
    }

    public static ExcelWriterTableBuilder tableBuilder() {
        return FastExcel.writerTable();
    }
}

