/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.core;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;

public class DropDownOptions {
    private int index = 0;
    private int nextIndex = 0;
    private List<String> options = new ArrayList<String>();
    private Map<String, List<String>> nextOptions = new HashMap<String, List<String>>();
    private static final String DELIMITER = "_";

    public DropDownOptions(int index, List<String> options) {
        this.index = index;
        this.options = options;
    }

    public static String createOptionValue(Object ... vars) {
        StringBuilder stringBuffer = new StringBuilder();
        String regex = "^[\\S\\d\\u4e00-\\u9fa5]+$";
        for (int i = 0; i < vars.length; ++i) {
            String var = StrUtil.trimToEmpty((CharSequence)Convert.toStr((Object)vars[i]));
            if (!var.matches(regex)) {
                throw new ServiceException("\u9009\u9879\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u4ec5\u5141\u8bb8\u4f7f\u7528\u4e2d\u82f1\u6587\u5b57\u7b26\u4ee5\u53ca\u6570\u5b57");
            }
            stringBuffer.append(var);
            if (i >= vars.length - 1) continue;
            stringBuffer.append(DELIMITER);
        }
        if (stringBuffer.toString().matches("^\\d_*$")) {
            throw new ServiceException("\u7981\u6b62\u4ee5\u6570\u5b57\u5f00\u5934");
        }
        return stringBuffer.toString();
    }

    public static List<String> analyzeOptionValue(String option) {
        return StrUtil.split((CharSequence)option, (CharSequence)DELIMITER, (boolean)true, (boolean)true);
    }

    public static <T> DropDownOptions buildLinkedOptions(List<T> parentList, int parentIndex, List<T> sonList, int sonIndex, Function<T, Number> parentHowToGetIdFunction, Function<T, Number> sonHowToGetParentIdFunction, Function<T, String> howToBuildEveryOption) {
        DropDownOptions parentLinkSonOptions = new DropDownOptions();
        parentLinkSonOptions.setIndex(parentIndex);
        parentLinkSonOptions.setOptions(parentList.stream().map(howToBuildEveryOption).collect(Collectors.toList()));
        HashMap<String, List<String>> sonOptions = new HashMap<String, List<String>>();
        Map parentGroupByIdMap = parentList.stream().collect(Collectors.groupingBy(parentHowToGetIdFunction));
        sonList.forEach(everySon -> {
            if (parentGroupByIdMap.containsKey(sonHowToGetParentIdFunction.apply(everySon))) {
                List<String> thisParentSonOptionList;
                Object parentObj = ((List)parentGroupByIdMap.get(sonHowToGetParentIdFunction.apply(everySon))).get(0);
                String key = (String)howToBuildEveryOption.apply(parentObj);
                if (sonOptions.containsKey(key)) {
                    thisParentSonOptionList = (List)sonOptions.get(key);
                } else {
                    thisParentSonOptionList = new ArrayList();
                    sonOptions.put(key, thisParentSonOptionList);
                }
                thisParentSonOptionList.add((String)howToBuildEveryOption.apply(everySon));
            }
        });
        parentLinkSonOptions.setNextIndex(sonIndex);
        parentLinkSonOptions.setNextOptions(sonOptions);
        return parentLinkSonOptions;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getNextIndex() {
        return this.nextIndex;
    }

    @Generated
    public List<String> getOptions() {
        return this.options;
    }

    @Generated
    public Map<String, List<String>> getNextOptions() {
        return this.nextOptions;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public void setNextIndex(int nextIndex) {
        this.nextIndex = nextIndex;
    }

    @Generated
    public void setOptions(List<String> options) {
        this.options = options;
    }

    @Generated
    public void setNextOptions(Map<String, List<String>> nextOptions) {
        this.nextOptions = nextOptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropDownOptions)) {
            return false;
        }
        DropDownOptions other = (DropDownOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getNextIndex() != other.getNextIndex()) {
            return false;
        }
        List<String> this$options = this.getOptions();
        List<String> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        Map<String, List<String>> this$nextOptions = this.getNextOptions();
        Map<String, List<String>> other$nextOptions = other.getNextOptions();
        return !(this$nextOptions == null ? other$nextOptions != null : !((Object)this$nextOptions).equals(other$nextOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DropDownOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getNextIndex();
        List<String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        Map<String, List<String>> $nextOptions = this.getNextOptions();
        result = result * 59 + ($nextOptions == null ? 43 : ((Object)$nextOptions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DropDownOptions(index=" + this.getIndex() + ", nextIndex=" + this.getNextIndex() + ", options=" + String.valueOf(this.getOptions()) + ", nextOptions=" + String.valueOf(this.getNextOptions()) + ")";
    }

    @Generated
    public DropDownOptions(int index, int nextIndex, List<String> options, Map<String, List<String>> nextOptions) {
        this.index = index;
        this.nextIndex = nextIndex;
        this.options = options;
        this.nextOptions = nextOptions;
    }

    @Generated
    public DropDownOptions() {
    }
}

