/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.idev.excel.metadata.ConfigurationHolder;
import cn.idev.excel.metadata.FieldCache;
import cn.idev.excel.metadata.FieldWrapper;
import cn.idev.excel.util.ClassUtils;
import cn.idev.excel.write.handler.SheetWriteHandler;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.holder.WriteWorkbookHolder;
import cn.smarthse.framework.core.utils.StreamUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.excel.annotation.ExcelDictFormat;
import cn.smarthse.framework.excel.annotation.ExcelEnumFormat;
import cn.smarthse.framework.excel.core.DropDownOptions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDownHandler
implements SheetWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelDownHandler.class);
    private static final String EXCEL_COLUMN_NAME = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String OPTIONS_SHEET_NAME = "options";
    private static final String LINKED_OPTIONS_SHEET_NAME = "linkedOptions";
    private final List<DropDownOptions> dropDownOptions;
    private int currentOptionsColumnIndex;
    private int currentLinkedOptionsSheetIndex;

    public ExcelDownHandler(List<DropDownOptions> options) {
        this.dropDownOptions = options;
        this.currentOptionsColumnIndex = 0;
        this.currentLinkedOptionsSheetIndex = 0;
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        FieldCache fieldCache = ClassUtils.declaredFields((Class)writeWorkbookHolder.getClazz(), (ConfigurationHolder)writeWorkbookHolder);
        for (Map.Entry entry : fieldCache.getSortedFieldMap().entrySet()) {
            Integer index = (Integer)entry.getKey();
            FieldWrapper wrapper = (FieldWrapper)entry.getValue();
            Field field = wrapper.getField();
            List<String> options = new ArrayList<String>();
            if (field.isAnnotationPresent(ExcelDictFormat.class)) {
                format = field.getDeclaredAnnotation(ExcelDictFormat.class);
                String converterExp = format.readConverterExp();
                if (StringUtils.isNotBlank((CharSequence)converterExp)) {
                    List strList = StringUtils.splitList((String)converterExp, (String)format.separator());
                    options = StreamUtils.toList((Collection)strList, s -> StringUtils.split((String)s, (String)"=")[1]);
                }
            } else if (field.isAnnotationPresent(ExcelEnumFormat.class)) {
                format = field.getDeclaredAnnotation(ExcelEnumFormat.class);
                List values = EnumUtil.getFieldValues(format.enumClass(), (String)format.textField());
                options = StreamUtils.toList((Collection)values, String::valueOf);
            }
            if (!ObjectUtil.isNotEmpty(options)) continue;
            if (options.size() > 20) {
                this.dropDownWithSheet(helper, workbook, sheet, index, options);
                continue;
            }
            this.dropDownWithSimple(helper, sheet, index, options);
        }
        if (CollUtil.isEmpty(this.dropDownOptions)) {
            return;
        }
        this.dropDownOptions.forEach(everyOptions -> {
            if (!everyOptions.getNextOptions().isEmpty()) {
                this.dropDownLinkedOptions(helper, workbook, sheet, (DropDownOptions)everyOptions);
            } else if (everyOptions.getOptions().size() > 10) {
                this.dropDownWithSheet(helper, workbook, sheet, everyOptions.getIndex(), everyOptions.getOptions());
            } else {
                this.dropDownWithSimple(helper, sheet, everyOptions.getIndex(), everyOptions.getOptions());
            }
        });
    }

    private void dropDownWithSimple(DataValidationHelper helper, Sheet sheet, Integer celIndex, List<String> value) {
        if (ObjectUtil.isEmpty(value)) {
            return;
        }
        this.markOptionsToSheet(helper, sheet, celIndex, helper.createExplicitListConstraint((String[])ArrayUtil.toArray(value, String.class)));
    }

    private void dropDownLinkedOptions(DataValidationHelper helper, Workbook workbook, Sheet sheet, DropDownOptions options) {
        String linkedOptionsSheetName = String.format("%s_%d", LINKED_OPTIONS_SHEET_NAME, this.currentLinkedOptionsSheetIndex);
        Sheet linkedOptionsDataSheet = workbook.createSheet(WorkbookUtil.createSafeSheetName((String)linkedOptionsSheetName));
        workbook.setSheetHidden(workbook.getSheetIndex(linkedOptionsDataSheet), true);
        List<String> firstOptions = options.getOptions();
        Map<String, List<String>> secoundOptionsMap = options.getNextOptions();
        ArrayList<String> columnNames = new ArrayList<String>();
        Row firstRow = linkedOptionsDataSheet.createRow(0);
        for (int columnIndex = 0; columnIndex < firstOptions.size(); ++columnIndex) {
            String columnName = firstOptions.get(columnIndex);
            firstRow.createCell(columnIndex).setCellValue(columnName);
            columnNames.add(columnName);
        }
        Name name = workbook.createName();
        name.setNameName(linkedOptionsSheetName);
        String firstOptionsFunction = String.format("%s!$%s$1:$%s$1", linkedOptionsSheetName, this.getExcelColumnName(0), this.getExcelColumnName(firstOptions.size()));
        name.setRefersToFormula(firstOptionsFunction);
        this.markOptionsToSheet(helper, sheet, options.getIndex(), helper.createFormulaListConstraint(linkedOptionsSheetName));
        for (int columIndex = 0; columIndex < columnNames.size(); ++columIndex) {
            String firstOptionsColumnName = this.getExcelColumnName(columIndex);
            String thisFirstOptionsValue = (String)columnNames.get(columIndex);
            Name sonName = workbook.createName();
            sonName.setNameName(thisFirstOptionsValue);
            String sonFunction = String.format("%s!$%s$2:$%s$%d", linkedOptionsSheetName, firstOptionsColumnName, firstOptionsColumnName, Math.max(Optional.ofNullable(secoundOptionsMap.get(thisFirstOptionsValue)).orElseGet(ArrayList::new).size(), 1) + 1);
            sonName.setRefersToFormula(sonFunction);
            String mainSheetFirstOptionsColumnName = this.getExcelColumnName(options.getIndex());
            for (int i = 0; i < 100; ++i) {
                String secondOptionsFunction = String.format("=INDIRECT(%s%d)", mainSheetFirstOptionsColumnName, i + 1);
                this.markLinkedOptionsToSheet(helper, sheet, i, options.getNextIndex(), helper.createFormulaListConstraint(secondOptionsFunction));
            }
        }
        HashMap<Integer, List> columnValueMap = new HashMap<Integer, List>();
        int currentRow = 1;
        while (currentRow >= 0) {
            boolean flag = false;
            ArrayList<String> rowData = new ArrayList<String>();
            for (String columnName : columnNames) {
                List<String> data = secoundOptionsMap.get(columnName);
                if (CollUtil.isEmpty(data)) {
                    rowData.add(" ");
                    continue;
                }
                String str = data.get(0);
                rowData.add(str);
                data.remove(0);
                flag = true;
            }
            columnValueMap.put(currentRow, rowData);
            if (flag) {
                ++currentRow;
                continue;
            }
            currentRow = -1;
        }
        columnValueMap.forEach((rowIndex, rowValues) -> {
            Row row = linkedOptionsDataSheet.createRow(rowIndex.intValue());
            for (int columnIndex = 0; columnIndex < rowValues.size(); ++columnIndex) {
                String rowValue = (String)rowValues.get(columnIndex);
                if (!StrUtil.isNotBlank((CharSequence)rowValue)) continue;
                row.createCell(columnIndex).setCellValue(rowValue);
            }
        });
        ++this.currentLinkedOptionsSheetIndex;
    }

    private void dropDownWithSheet(DataValidationHelper helper, Workbook workbook, Sheet sheet, Integer celIndex, List<String> value) {
        String tmpOptionsSheetName = "options_" + this.currentOptionsColumnIndex;
        Sheet simpleDataSheet = Optional.ofNullable(workbook.getSheet(WorkbookUtil.createSafeSheetName((String)tmpOptionsSheetName))).orElseGet(() -> workbook.createSheet(WorkbookUtil.createSafeSheetName((String)tmpOptionsSheetName)));
        workbook.setSheetHidden(workbook.getSheetIndex(simpleDataSheet), true);
        for (int i = 0; i < value.size(); ++i) {
            int finalI = i;
            Row row = Optional.ofNullable(simpleDataSheet.getRow(i)).orElseGet(() -> simpleDataSheet.createRow(finalI));
            Cell cell = Optional.ofNullable(row.getCell(0)).orElseGet(() -> row.createCell(0));
            cell.setCellValue(value.get(i));
        }
        Name name = workbook.createName();
        String nameName = String.format("%s_%d", tmpOptionsSheetName, celIndex);
        name.setNameName(nameName);
        String function = String.format("%s!$%s$1:$%s$%d", tmpOptionsSheetName, this.getExcelColumnName(0), this.getExcelColumnName(0), value.size());
        name.setRefersToFormula(function);
        this.markOptionsToSheet(helper, sheet, celIndex, helper.createFormulaListConstraint(nameName));
        ++this.currentOptionsColumnIndex;
    }

    private void markOptionsToSheet(DataValidationHelper helper, Sheet sheet, Integer celIndex, DataValidationConstraint constraint) {
        CellRangeAddressList addressList = new CellRangeAddressList(1, 1000, celIndex.intValue(), celIndex.intValue());
        this.markDataValidationToSheet(helper, sheet, constraint, addressList);
    }

    private void markLinkedOptionsToSheet(DataValidationHelper helper, Sheet sheet, Integer rowIndex, Integer celIndex, DataValidationConstraint constraint) {
        CellRangeAddressList addressList = new CellRangeAddressList(rowIndex.intValue(), rowIndex.intValue(), celIndex.intValue(), celIndex.intValue());
        this.markDataValidationToSheet(helper, sheet, constraint, addressList);
    }

    private void markDataValidationToSheet(DataValidationHelper helper, Sheet sheet, DataValidationConstraint constraint, CellRangeAddressList addressList) {
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setErrorStyle(0);
            dataValidation.createErrorBox("\u63d0\u793a", "\u6b64\u503c\u4e0e\u5355\u5143\u683c\u5b9a\u4e49\u6570\u636e\u4e0d\u4e00\u81f4");
            dataValidation.setShowErrorBox(true);
            dataValidation.createPromptBox("\u586b\u5199\u8bf4\u660e\uff1a", "\u586b\u5199\u5185\u5bb9\u53ea\u80fd\u4e3a\u4e0b\u62c9\u4e2d\u6570\u636e\uff0c\u5176\u4ed6\u6570\u636e\u5c06\u5bfc\u81f4\u5bfc\u5165\u5931\u8d25");
            dataValidation.setShowPromptBox(true);
            sheet.addValidationData(dataValidation);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private String getExcelColumnName(int columnIndex) {
        int columnCircleCount = columnIndex / 26;
        int thisCircleColumnIndex = columnIndex % 26;
        String columnPrefix = columnCircleCount == 0 ? "" : StrUtil.subWithLength((String)EXCEL_COLUMN_NAME, (int)(columnCircleCount - 1), (int)1);
        String columnNext = StrUtil.subWithLength((String)EXCEL_COLUMN_NAME, (int)thisCircleColumnIndex, (int)1);
        return columnPrefix + columnNext;
    }
}

