/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.write.handler.WorkbookWriteHandler;
import cn.idev.excel.write.handler.context.WorkbookWriteHandlerContext;
import cn.idev.excel.write.merge.AbstractMergeStrategy;
import cn.smarthse.framework.core.utils.ReflectUtils;
import cn.smarthse.framework.excel.annotation.CellMerge;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellMergeStrategy
extends AbstractMergeStrategy
implements WorkbookWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CellMergeStrategy.class);
    private final List<CellRangeAddress> cellList;
    private final boolean hasTitle;
    private int rowIndex;

    public CellMergeStrategy(List<?> list, boolean hasTitle) {
        this.hasTitle = hasTitle;
        this.rowIndex = hasTitle ? 1 : 0;
        this.cellList = this.handle(list, hasTitle);
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        int rowIndex = cell.getRowIndex();
        if (CollUtil.isNotEmpty(this.cellList)) {
            for (CellRangeAddress cellAddresses : this.cellList) {
                int firstRow = cellAddresses.getFirstRow();
                if (!cellAddresses.isInRange(cell) || rowIndex == firstRow) continue;
                cell.setBlank();
            }
        }
    }

    public void afterWorkbookDispose(WorkbookWriteHandlerContext context) {
        if (CollUtil.isNotEmpty(this.cellList)) {
            for (CellRangeAddress item : this.cellList) {
                context.getWriteContext().writeSheetHolder().getSheet().addMergedRegion(item);
            }
        }
    }

    private List<CellRangeAddress> handle(List<?> list, boolean hasTitle) {
        ArrayList<CellRangeAddress> cellList = new ArrayList<CellRangeAddress>();
        if (CollUtil.isEmpty(list)) {
            return cellList;
        }
        Field[] fields = ReflectUtils.getFields(list.get(0).getClass(), field -> !"serialVersionUID".equals(field.getName()));
        ArrayList<Field> mergeFields = new ArrayList<Field>();
        ArrayList<Integer> mergeFieldsIndex = new ArrayList<Integer>();
        for (int i = 0; i < fields.length; ++i) {
            Field field2 = fields[i];
            if (!field2.isAnnotationPresent(CellMerge.class)) continue;
            CellMerge cm = field2.getAnnotation(CellMerge.class);
            mergeFields.add(field2);
            mergeFieldsIndex.add(cm.index() == -1 ? i : cm.index());
            if (!hasTitle) continue;
            ExcelProperty property = field2.getAnnotation(ExcelProperty.class);
            this.rowIndex = Math.max(this.rowIndex, property.value().length);
        }
        HashMap<Field, RepeatCell> map = new HashMap<Field, RepeatCell>();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < mergeFields.size(); ++j) {
                Field field3 = (Field)mergeFields.get(j);
                Object val = ReflectUtils.invokeGetter(list.get(i), (String)field3.getName());
                int colNum = (Integer)mergeFieldsIndex.get(j);
                if (!map.containsKey(field3)) {
                    map.put(field3, new RepeatCell(val, i));
                    continue;
                }
                RepeatCell repeatCell = (RepeatCell)map.get(field3);
                Object cellValue = repeatCell.getValue();
                if (cellValue == null || "".equals(cellValue)) continue;
                if (!cellValue.equals(val)) {
                    if (i - repeatCell.getCurrent() > 1) {
                        cellList.add(new CellRangeAddress(repeatCell.getCurrent() + this.rowIndex, i + this.rowIndex - 1, colNum, colNum));
                    }
                    map.put(field3, new RepeatCell(val, i));
                    continue;
                }
                if (i == list.size() - 1) {
                    if (!this.isMerge(list, i, field3)) {
                        if (i - repeatCell.getCurrent() <= 1) continue;
                        cellList.add(new CellRangeAddress(repeatCell.getCurrent() + this.rowIndex, i + this.rowIndex - 1, colNum, colNum));
                        continue;
                    }
                    if (i <= repeatCell.getCurrent()) continue;
                    cellList.add(new CellRangeAddress(repeatCell.getCurrent() + this.rowIndex, i + this.rowIndex, colNum, colNum));
                    continue;
                }
                if (this.isMerge(list, i, field3)) continue;
                if (i - repeatCell.getCurrent() > 1) {
                    cellList.add(new CellRangeAddress(repeatCell.getCurrent() + this.rowIndex, i + this.rowIndex - 1, colNum, colNum));
                }
                map.put(field3, new RepeatCell(val, i));
            }
        }
        return cellList;
    }

    private boolean isMerge(List<?> list, int i, Field field) {
        boolean isMerge = true;
        CellMerge cm = field.getAnnotation(CellMerge.class);
        CharSequence[] mergeBy = cm.mergeBy();
        if (StrUtil.isAllNotBlank((CharSequence[])mergeBy)) {
            for (CharSequence fieldName : mergeBy) {
                Object valCurrent = ReflectUtil.getFieldValue(list.get(i), (String)fieldName);
                Object valPre = ReflectUtil.getFieldValue(list.get(i - 1), (String)fieldName);
                if (Objects.equals(valPre, valCurrent)) continue;
                isMerge = false;
            }
        }
        return isMerge;
    }

    static class RepeatCell {
        private Object value;
        private int current;

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public int getCurrent() {
            return this.current;
        }

        @Generated
        public void setValue(Object value) {
            this.value = value;
        }

        @Generated
        public void setCurrent(int current) {
            this.current = current;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepeatCell)) {
                return false;
            }
            RepeatCell other = (RepeatCell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCurrent() != other.getCurrent()) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RepeatCell;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCurrent();
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CellMergeStrategy.RepeatCell(value=" + String.valueOf(this.getValue()) + ", current=" + this.getCurrent() + ")";
        }

        @Generated
        public RepeatCell(Object value, int current) {
            this.value = value;
            this.current = current;
        }
    }
}

