/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.convert;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.idev.excel.converters.Converter;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.smarthse.framework.core.utils.ReflectUtils;
import cn.smarthse.framework.excel.annotation.ExcelEnumFormat;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelEnumConvert
implements Converter<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelEnumConvert.class);

    public Class<Object> supportJavaTypeKey() {
        return Object.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public Object convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        cellData.checkEmpty();
        Object textValue = switch (cellData.getType()) {
            case CellDataTypeEnum.STRING, CellDataTypeEnum.DIRECT_STRING, CellDataTypeEnum.RICH_TEXT_STRING -> cellData.getStringValue();
            case CellDataTypeEnum.NUMBER -> cellData.getNumberValue();
            case CellDataTypeEnum.BOOLEAN -> cellData.getBooleanValue();
            default -> throw new IllegalArgumentException("\u5355\u5143\u683c\u7c7b\u578b\u5f02\u5e38!");
        };
        if (ObjectUtil.isNull((Object)textValue)) {
            return null;
        }
        Map<Object, String> enumCodeToTextMap = this.beforeConvert(contentProperty);
        HashMap enumTextToCodeMap = new HashMap();
        enumCodeToTextMap.forEach((key, value) -> enumTextToCodeMap.put(value, key));
        Object codeValue = enumTextToCodeMap.get(textValue);
        return Convert.convert(contentProperty.getField().getType(), codeValue);
    }

    public WriteCellData<String> convertToExcelData(Object object, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (ObjectUtil.isNull((Object)object)) {
            return new WriteCellData("");
        }
        Map<Object, String> enumValueMap = this.beforeConvert(contentProperty);
        String value = Convert.toStr((Object)enumValueMap.get(object), (String)"");
        return new WriteCellData(value);
    }

    private Map<Object, String> beforeConvert(ExcelContentProperty contentProperty) {
        Enum<?>[] enumConstants;
        ExcelEnumFormat anno = this.getAnnotation(contentProperty.getField());
        HashMap<Object, String> enumValueMap = new HashMap<Object, String>();
        for (Enum<?> enumConstant : enumConstants = anno.enumClass().getEnumConstants()) {
            Object codeValue = ReflectUtils.invokeGetter(enumConstant, (String)anno.codeField());
            String textValue = (String)ReflectUtils.invokeGetter(enumConstant, (String)anno.textField());
            enumValueMap.put(codeValue, textValue);
        }
        return enumValueMap;
    }

    private ExcelEnumFormat getAnnotation(Field field) {
        return (ExcelEnumFormat)AnnotationUtil.getAnnotation((AnnotatedElement)field, ExcelEnumFormat.class);
    }
}

