/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.asymmetric.SM2;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class EncryptUtils {
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";

    public static String encryptByBase64(String data) {
        return Base64.encode((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public static String decryptByBase64(String data) {
        return Base64.decodeStr((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public static String encryptByAes(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptBase64(data, StandardCharsets.UTF_8);
    }

    public static String encryptByAesHex(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptHex(data, StandardCharsets.UTF_8);
    }

    public static String decryptByAes(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).decryptStr(data, StandardCharsets.UTF_8);
    }

    public static String encryptBySm4(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int sm4PasswordLength = 16;
        if (sm4PasswordLength != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d");
        }
        return SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptBase64(data, StandardCharsets.UTF_8);
    }

    public static String encryptBySm4Hex(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int sm4PasswordLength = 16;
        if (sm4PasswordLength != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d");
        }
        return SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptHex(data, StandardCharsets.UTF_8);
    }

    public static String decryptBySm4(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int sm4PasswordLength = 16;
        if (sm4PasswordLength != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d");
        }
        return SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8)).decryptStr(data, StandardCharsets.UTF_8);
    }

    public static Map<String, String> generateSm2Key() {
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        SM2 sm2 = SmUtil.sm2();
        keyMap.put(PRIVATE_KEY, sm2.getPrivateKeyBase64());
        keyMap.put(PUBLIC_KEY, sm2.getPublicKeyBase64());
        return keyMap;
    }

    public static String encryptBySm2(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("SM2\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        SM2 sm2 = SmUtil.sm2(null, (String)publicKey);
        return sm2.encryptBase64(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String encryptBySm2Hex(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("SM2\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        SM2 sm2 = SmUtil.sm2(null, (String)publicKey);
        return sm2.encryptHex(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String decryptBySm2(String data, String privateKey) {
        if (StrUtil.isBlank((CharSequence)privateKey)) {
            throw new IllegalArgumentException("SM2\u9700\u8981\u4f20\u5165\u79c1\u94a5\u8fdb\u884c\u89e3\u5bc6");
        }
        SM2 sm2 = SmUtil.sm2((String)privateKey, null);
        return sm2.decryptStr(data, KeyType.PrivateKey, StandardCharsets.UTF_8);
    }

    public static Map<String, String> generateRsaKey() {
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        RSA rsa = SecureUtil.rsa();
        keyMap.put(PRIVATE_KEY, rsa.getPrivateKeyBase64());
        keyMap.put(PUBLIC_KEY, rsa.getPublicKeyBase64());
        return keyMap;
    }

    public static String encryptByRsa(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        RSA rsa = SecureUtil.rsa(null, (String)publicKey);
        return rsa.encryptBase64(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String encryptByRsaHex(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        RSA rsa = SecureUtil.rsa(null, (String)publicKey);
        return rsa.encryptHex(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String decryptByRsa(String data, String privateKey) {
        if (StrUtil.isBlank((CharSequence)privateKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u79c1\u94a5\u8fdb\u884c\u89e3\u5bc6");
        }
        RSA rsa = SecureUtil.rsa((String)privateKey, null);
        return rsa.decryptStr(data, KeyType.PrivateKey, StandardCharsets.UTF_8);
    }

    public static String encryptByMd5(String data) {
        return SecureUtil.md5((String)data);
    }

    public static String encryptBySha256(String data) {
        return SecureUtil.sha256((String)data);
    }

    public static String encryptBySm3(String data) {
        return SmUtil.sm3((String)data);
    }
}

