/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class MybatisDecryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisDecryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final EncryptorProperties defaultProperties;
    private final List<EncryptorProperties.GroupConfig> groupConfigs = new CopyOnWriteArrayList<EncryptorProperties.GroupConfig>();

    public MybatisDecryptInterceptor(EncryptorManager encryptorManager, EncryptorProperties defaultProperties) {
        this.encryptorManager = encryptorManager;
        this.defaultProperties = defaultProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        ParameterHandler parameterHandler;
        Object parameterObject;
        ResultSetHandler resultSetHandler = (ResultSetHandler)invocation.getTarget();
        Field parameterHandlerField = resultSetHandler.getClass().getDeclaredField("parameterHandler");
        parameterHandlerField.setAccessible(true);
        Object target = parameterHandlerField.get(resultSetHandler);
        if (target instanceof ParameterHandler && ObjectUtil.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            this.decryptHandler(parameterObject);
        }
        if ((result = invocation.proceed()) == null) {
            return null;
        }
        this.decryptHandler(result);
        return result;
    }

    private void decryptHandler(Object sourceObject) {
        if (ObjectUtil.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            new HashSet(map.values()).forEach(this::decryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtil.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::decryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtil.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            try {
                field.set(sourceObject, this.decryptField(Convert.toStr((Object)field.get(sourceObject)), field));
            }
            catch (Exception e) {
                try {
                    field.set(sourceObject, null);
                }
                catch (IllegalAccessException ex) {
                    log.error("\u5904\u7406\u89e3\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519\uff0c\u8bbe\u7f6e\u4e3anull\u5931\u8d25", (Throwable)ex);
                }
                log.error("\u5904\u7406\u89e3\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private String decryptField(String value, Field field) {
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        if (value.length() < 14) {
            throw new IllegalArgumentException("\u89e3\u5bc6\u503c\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e14\uff0c\u5b9e\u9645\u503c\uff1a" + value);
        }
        if (CollUtil.isEmpty(this.groupConfigs)) {
            for (EncryptorProperties.GroupConfig groupConfig2 : this.defaultProperties.getGroupConfigs()) {
                EncryptorProperties.GroupConfig dto = new EncryptorProperties.GroupConfig();
                dto.setVersion(StrUtil.subSuf((CharSequence)groupConfig2.getVersion(), (int)6));
                dto.setPassword(groupConfig2.getPassword());
                dto.setPublicKey(groupConfig2.getPublicKey());
                dto.setPrivateKey(groupConfig2.getPrivateKey());
                this.groupConfigs.add(dto);
            }
        }
        String subValue = StrUtil.subPre((CharSequence)value, (int)14);
        String version = StrUtil.subSuf((CharSequence)subValue, (int)6);
        EncryptorProperties.GroupConfig versionGroupConfig = this.groupConfigs.stream().filter(groupConfig -> StrUtil.equals((CharSequence)groupConfig.getVersion(), (CharSequence)version)).findFirst().orElseThrow(() -> new RuntimeException("\u89e3\u5bc6\u672a\u627e\u5230\u5bf9\u5e94\u7248\u672c\uff1a" + version + "\uff0c\u539f\u59cb\u503c\uff1a" + value));
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setEncode(EncodeType.BASE64);
        encryptContext.setPassword(versionGroupConfig.getPassword());
        encryptContext.setPrivateKey(versionGroupConfig.getPrivateKey());
        encryptContext.setPublicKey(versionGroupConfig.getPublicKey());
        encryptContext.setDataProcessingMethodsType(ObjectUtil.isNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? DataProcessingMethodsType.VAGUE : encryptField.dataProcessingMethodsType());
        encryptContext.setVersion(versionGroupConfig.getVersion());
        return this.encryptorManager.decrypt(value, encryptContext);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

