/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.core.MybatisParameterHandler;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.Example;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class MybatisEncryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisEncryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final FieldEncryptorProperties fieldEncryptionProperties;
    private static final Field BOUND_SQL_FIELD;
    private static Field META_PARAMETERS_FIELD;
    private static Field ORIGINAL_OBJECT_FIELD;
    private static final Map<Class<?>, List<Field>> FIELD_CACHE;
    private static final Map<Field, DataProcessingMethodsType> FIELD_ANNOTATION_CACHE;
    private static final Pattern PARAM_PAIRS_PATTERN;
    private static final Pattern FIELD_NAME_PATTERN;
    private volatile AlgorithmType cachedAlgorithmType;
    private volatile boolean cachedMiddlewareEnabled;
    private volatile FieldEncryptorProperties.GroupConfig cachedGroupConfig;

    public MybatisEncryptInterceptor(EncryptorManager encryptorManager, FieldEncryptorProperties fieldEncryptionProperties) {
        this.encryptorManager = encryptorManager;
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }

    public Object intercept(Invocation invocation) {
        return invocation;
    }

    public Object plugin(Object target) {
        ParameterHandler parameterHandler;
        Object parameterObject;
        if (target instanceof ParameterHandler && ObjectUtils.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            HashMap<Object, Object> copyParameterObject = null;
            if (parameterObject instanceof Map && parameterHandler instanceof MybatisParameterHandler) {
                copyParameterObject = new HashMap<Object, Object>((Map)parameterObject);
                MybatisParameterHandler mybatisParameterHandler = (MybatisParameterHandler)target;
                parameterObject = this.getMybatisParameterHandlerOriginalParameter(mybatisParameterHandler);
            }
            this.encryptHandler(parameterObject);
            if (ObjectUtils.isNotNull(copyParameterObject) && !Objects.equals(copyParameterObject, parameterObject)) {
                Map<String, Object> afterMap = this.getFieldAndValueMap(parameterObject);
                HashMap<String, Object> beforeMap = new HashMap<String, Object>(copyParameterObject.size() + afterMap.size());
                copyParameterObject.forEach((key, value) -> beforeMap.put(key.toString(), value));
                beforeMap.putAll(afterMap);
                try {
                    Field parameterObjectField = DefaultParameterHandler.class.getDeclaredField("parameterObject");
                    parameterObjectField.setAccessible(true);
                    parameterObjectField.set(target, beforeMap);
                }
                catch (Exception e) {
                    log.error("[Encrypt] [\u53c2\u6570\u8986\u76d6\u5f02\u5e38] [failure] [error] [unknown] errorMsg={} exceptionClass={}", new Object[]{e.getMessage(), e.getClass().getSimpleName(), e});
                }
            }
        }
        return target;
    }

    private Object getMybatisParameterHandlerOriginalParameter(MybatisParameterHandler parameterHandler) {
        try {
            Object originalObject;
            Object boundSql = BOUND_SQL_FIELD.get(parameterHandler);
            if (ObjectUtils.isNull((Object)META_PARAMETERS_FIELD)) {
                Field metaParametersField = boundSql.getClass().getDeclaredField("metaParameters");
                metaParametersField.setAccessible(true);
                META_PARAMETERS_FIELD = metaParametersField;
            }
            Object metaParameters = META_PARAMETERS_FIELD.get(boundSql);
            if (ObjectUtils.isNull((Object)ORIGINAL_OBJECT_FIELD)) {
                Field originalObjectField = metaParameters.getClass().getDeclaredField("originalObject");
                originalObjectField.setAccessible(true);
                ORIGINAL_OBJECT_FIELD = originalObjectField;
            }
            if ((originalObject = ORIGINAL_OBJECT_FIELD.get(metaParameters)) instanceof Map) {
                Map map = (Map)originalObject;
                Object obj = map.get("_parameter");
                return ObjectUtils.isNull(obj) ? parameterHandler.getParameterObject() : obj;
            }
        }
        catch (Exception e) {
            log.error("[Encrypt] [\u53c2\u6570\u63d0\u53d6\u5f02\u5e38] [failure] [error] [unknown] errorMsg={} exceptionClass={}", new Object[]{e.getMessage(), e.getClass().getSimpleName(), e});
        }
        return null;
    }

    private Map<String, Object> getFieldAndValueMap(Object obj) {
        if (ObjectUtils.isNull((Object)obj)) {
            return MapUtil.newHashMap();
        }
        Class<?> clazz = obj.getClass();
        List fields = FIELD_CACHE.computeIfAbsent(clazz, c -> {
            if (c.getName().startsWith("java.") || c.getName().startsWith("javax.")) {
                return CollUtil.newArrayList((Object[])new Field[0]);
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class currentClass = c; ObjectUtils.isNotNull((Object)currentClass) && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] declaredFields;
                for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                    if (field.getDeclaringClass().getName().startsWith("java.") || field.getDeclaringClass().getName().startsWith("javax.")) continue;
                    field.setAccessible(true);
                    fieldList.add(field);
                }
            }
            return fieldList;
        });
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(fields.size());
        for (Field field : fields) {
            try {
                fieldMap.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                log.error("[Encrypt] [\u5b57\u6bb5\u8bbf\u95ee\u5f02\u5e38] [failure] [error] [unknown] fieldName={} errorMsg={} exceptionClass={}", new Object[]{field.getName(), e.getMessage(), e.getClass().getSimpleName(), e});
            }
        }
        return fieldMap;
    }

    private void encryptHandler(Object sourceObject) {
        if (ObjectUtils.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            this.encryptMap(map);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtils.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::encryptHandler);
            return;
        }
        if (sourceObject.getClass().getName().contains("tk.mybatis.mapper.entity.Example")) {
            this.encryptTkMapperExample(sourceObject);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtils.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            try {
                String originalValue = Convert.toStr((Object)field.get(sourceObject));
                String encryptedValue = this.encryptField(originalValue, field);
                field.set(sourceObject, encryptedValue);
            }
            catch (Exception e) {
                log.error("[Encrypt] [\u52a0\u5bc6\u5b57\u6bb5\u5f02\u5e38] [failure] [error] [unknown] fieldName={} errorMsg={} exceptionClass={}", new Object[]{field.getName(), e.getMessage(), e.getClass().getSimpleName(), e});
                throw new RuntimeException("\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", e);
            }
        }
    }

    private void encryptMap(Map<?, ?> parameterMap) {
        Object parameter;
        if (parameterMap.containsKey("ew") && (parameter = parameterMap.get("ew")) != null) {
            this.encryptWrapper(parameter);
        }
        new HashSet(parameterMap.values()).forEach(this::encryptHandler);
    }

    private void encryptWrapper(Object parameter) {
        block11: {
            block10: {
                if (!(parameter instanceof UpdateWrapper) && !(parameter instanceof LambdaUpdateWrapper)) break block10;
                AbstractWrapper updateWrapper = (AbstractWrapper)parameter;
                String sqlSet = updateWrapper.getSqlSet();
                if (StrUtil.isBlank((CharSequence)sqlSet)) {
                    return;
                }
                Map propMap = Arrays.stream(sqlSet.split(",")).map(s -> s.split("=", 2)).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0].trim(), parts -> parts[1].trim(), (existing, replacement) -> existing, HashMap::new));
                Class<?> entityClass = this.getEntityClassFromWrapper(updateWrapper);
                if (entityClass == null) {
                    return;
                }
                Set<Field> encryptFieldSet = this.encryptorManager.getFieldCache(entityClass);
                if (ObjectUtils.isNull(encryptFieldSet)) {
                    return;
                }
                for (Field field : encryptFieldSet) {
                    Matcher matcher;
                    EncryptField encryptField = field.getAnnotation(EncryptField.class);
                    if (encryptField == null) continue;
                    String el = (String)propMap.get(field.getName());
                    if (StrUtil.isBlank((CharSequence)el)) {
                        String columnName = StrUtil.toUnderlineCase((CharSequence)field.getName());
                        el = (String)propMap.get(columnName);
                    }
                    if (StrUtil.isBlank((CharSequence)el) || !(matcher = PARAM_PAIRS_PATTERN.matcher(el)).matches()) continue;
                    String valueKey = matcher.group(1);
                    Object value = updateWrapper.getParamNameValuePairs().get(valueKey);
                    if (!(value instanceof String)) continue;
                    String strValue = (String)value;
                    String encryptedValue = this.encryptField(strValue, field);
                    updateWrapper.getParamNameValuePairs().put(valueKey, encryptedValue);
                }
                break block11;
            }
            if (!(parameter instanceof QueryWrapper) && !(parameter instanceof LambdaQueryWrapper)) break block11;
            AbstractWrapper queryWrapper = (AbstractWrapper)parameter;
            Class<?> entityClass = this.getEntityClassFromWrapper(queryWrapper);
            if (entityClass == null) {
                return;
            }
            Set<Field> encryptFieldSet = this.encryptorManager.getFieldCache(entityClass);
            if (ObjectUtils.isNull(encryptFieldSet)) {
                return;
            }
            Map paramNameValuePairs = queryWrapper.getParamNameValuePairs();
            if (paramNameValuePairs != null && !paramNameValuePairs.isEmpty()) {
                for (Field field : encryptFieldSet) {
                    EncryptField encryptField = field.getAnnotation(EncryptField.class);
                    if (encryptField == null) continue;
                    for (Map.Entry entry : paramNameValuePairs.entrySet()) {
                        Object value = entry.getValue();
                        if (!(value instanceof String)) continue;
                        String strValue = (String)value;
                        String encryptedValue = this.encryptField(strValue, field);
                        paramNameValuePairs.put((String)entry.getKey(), encryptedValue);
                    }
                }
            }
        }
    }

    private Class<?> getEntityClassFromWrapper(AbstractWrapper<?, ?, ?> wrapper) {
        Class entityClass = wrapper.getEntityClass();
        if (entityClass != null) {
            return entityClass;
        }
        log.warn("[Encrypt] [\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b] [warning] [warn] [unknown] message=\u65e0\u6cd5\u4eceWrapper\u4e2d\u83b7\u53d6\u5b9e\u4f53\u7c7b");
        return null;
    }

    private void encryptTkMapperExample(Object sourceObject) {
        if (sourceObject instanceof Example) {
            Example example = (Example)sourceObject;
            Class entityClass = example.getEntityClass();
            if (entityClass == null) {
                return;
            }
            Set<Field> encryptFieldSet = this.encryptorManager.getFieldCache(entityClass);
            if (ObjectUtils.isNull(encryptFieldSet)) {
                return;
            }
            List oredCriteria = example.getOredCriteria();
            if (oredCriteria != null && !oredCriteria.isEmpty()) {
                for (Example.Criteria criteria : oredCriteria) {
                    List criterionList = criteria.getAllCriteria();
                    if (criterionList == null || criterionList.isEmpty()) continue;
                    for (Example.Criterion criterion : criterionList) {
                        String condition = criterion.getCondition();
                        String fieldName = this.extractFieldNameFromCondition(condition);
                        if (fieldName == null) continue;
                        for (Field field : encryptFieldSet) {
                            try {
                                Object value = criterion.getValue();
                                Object processedValue = this.processCriterionValue(value, field);
                                Field valueField = Example.Criterion.class.getDeclaredField("value");
                                valueField.setAccessible(true);
                                valueField.set(criterion, processedValue);
                                Object secondValue = criterion.getSecondValue();
                                Object processedSecondValue = this.processCriterionValue(secondValue, field);
                                Field secondValueField = Example.Criterion.class.getDeclaredField("secondValue");
                                secondValueField.setAccessible(true);
                                secondValueField.set(criterion, processedSecondValue);
                            }
                            catch (Exception e) {
                                log.warn("[Encrypt] [TKMapper Criterion\u5904\u7406\u5f02\u5e38] [warning] [warn] [unknown] fieldName={} message=\u65e0\u6cd5\u5904\u7406Criterion\u4e2d\u7684\u503c", (Object)fieldName, (Object)e);
                            }
                        }
                    }
                }
            }
        }
    }

    private String extractFieldNameFromCondition(String condition) {
        if (StrUtil.isBlank((CharSequence)condition)) {
            return condition;
        }
        String upperCondition = condition.toUpperCase().trim();
        if (upperCondition.matches("^\\s*\\w+\\s+(NOT\\s+)?IN\\b.*")) {
            return null;
        }
        Matcher matcher = FIELD_NAME_PATTERN.matcher(condition);
        if (matcher.find()) {
            return matcher.group(1);
        }
        condition = condition.trim();
        int spaceIndex = -1;
        for (int i = 0; i < condition.length(); ++i) {
            if (!Character.isWhitespace(condition.charAt(i))) continue;
            spaceIndex = i;
            break;
        }
        if (spaceIndex > 0) {
            return condition.substring(0, spaceIndex);
        }
        return condition;
    }

    private Object processCriterionValue(Object value, Field encryptField) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.encryptField((String)value, encryptField);
        }
        if (value instanceof List) {
            List originalList = (List)value;
            ArrayList<String> encryptedList = new ArrayList<String>(originalList.size());
            for (Object item : originalList) {
                String stringValue = Convert.toStr(item);
                encryptedList.add(this.encryptField(stringValue, encryptField));
            }
            return encryptedList;
        }
        String stringValue = Convert.toStr((Object)value);
        return this.encryptField(stringValue, encryptField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encryptField(String value, Field field) {
        byte[] data;
        if (StrUtil.isBlank((CharSequence)value)) {
            return value;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("[Encrypt] [\u91cd\u590d\u52a0\u5bc6\u8b66\u544a] [warning] [warn] [unknown] fieldName={} originalValue={} message=\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6", (Object)field.getName(), (Object)value);
            return value;
        }
        if (ObjectUtils.isNull((Object)((Object)this.cachedAlgorithmType))) {
            MybatisEncryptInterceptor mybatisEncryptInterceptor = this;
            synchronized (mybatisEncryptInterceptor) {
                if (ObjectUtils.isNull((Object)((Object)this.cachedAlgorithmType))) {
                    this.cachedAlgorithmType = AlgorithmType.getByName(this.fieldEncryptionProperties.getAlgorithm());
                    this.cachedMiddlewareEnabled = this.fieldEncryptionProperties.getMiddlewareEnabled();
                    this.cachedGroupConfig = this.fieldEncryptionProperties.getMaxVersionGroupConfig();
                }
            }
        }
        if (AlgorithmType.WCSP_LIGHT_DATA_SERVICE.equals((Object)this.cachedAlgorithmType) && (data = value.getBytes(StandardCharsets.UTF_8)).length > 1023) {
            throw new IllegalArgumentException(String.format("Input data is too long for algorithm %s. Max length: 1023, Actual length: %d, Field: %s", this.cachedAlgorithmType.getName(), data.length, field.getName()));
        }
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setMiddlewareEnabled(this.cachedMiddlewareEnabled);
        encryptContext.setAlgorithm(this.cachedAlgorithmType);
        DataProcessingMethodsType processingType = FIELD_ANNOTATION_CACHE.computeIfAbsent(field, f -> {
            EncryptField encryptField = f.getAnnotation(EncryptField.class);
            return ObjectUtils.isNotNull((Object)encryptField) && ObjectUtils.isNotNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? encryptField.dataProcessingMethodsType() : DataProcessingMethodsType.ACCURATE;
        });
        encryptContext.setDataProcessingMethodsType(processingType);
        encryptContext.setVersion(this.cachedGroupConfig.getVersion());
        encryptContext.setPassword(this.cachedGroupConfig.getPassword());
        encryptContext.setPublicKey(this.cachedGroupConfig.getPublicKey());
        encryptContext.setPrivateKey(this.cachedGroupConfig.getPrivateKey());
        return this.encryptorManager.encrypt(value, encryptContext);
    }

    public void setProperties(Properties properties) {
    }

    static {
        FIELD_CACHE = new ConcurrentHashMap();
        FIELD_ANNOTATION_CACHE = new ConcurrentHashMap<Field, DataProcessingMethodsType>();
        PARAM_PAIRS_PATTERN = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)}");
        FIELD_NAME_PATTERN = Pattern.compile("^\\s*(\\w+)");
        try {
            BOUND_SQL_FIELD = MybatisParameterHandler.class.getSuperclass().getDeclaredField("boundSql");
            BOUND_SQL_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

