/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class MybatisDecryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisDecryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final FieldEncryptorProperties fieldEncryptionProperties;
    private static final Map<Field, DataProcessingMethodsType> FIELD_ANNOTATION_CACHE = new ConcurrentHashMap<Field, DataProcessingMethodsType>();
    private volatile AlgorithmType cachedAlgorithmType;
    private volatile boolean cachedMiddlewareEnabled;
    private volatile FieldEncryptorProperties.GroupConfig cachedGroupConfig;

    public MybatisDecryptInterceptor(EncryptorManager encryptorManager, FieldEncryptorProperties fieldEncryptionProperties) {
        this.encryptorManager = encryptorManager;
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        ParameterHandler parameterHandler;
        Object parameterObject;
        ResultSetHandler resultSetHandler = (ResultSetHandler)invocation.getTarget();
        Field parameterHandlerField = resultSetHandler.getClass().getDeclaredField("parameterHandler");
        parameterHandlerField.setAccessible(true);
        Object target = parameterHandlerField.get(resultSetHandler);
        if (target instanceof ParameterHandler && ObjectUtils.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            this.decryptHandler(parameterObject);
        }
        if ((result = invocation.proceed()) == null) {
            return null;
        }
        this.decryptHandler(result);
        return result;
    }

    private void decryptHandler(Object sourceObject) {
        if (ObjectUtils.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            new HashSet(map.values()).forEach(this::decryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtils.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::decryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtils.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            try {
                String originalValue = Convert.toStr((Object)field.get(sourceObject));
                String decryptedValue = this.decryptField(originalValue, field);
                field.set(sourceObject, decryptedValue);
            }
            catch (Exception e) {
                log.error("[Decrypt] [\u5b57\u6bb5\u89e3\u5bc6\u5f02\u5e38] [failure] [error] [unknown] fieldName={} className={} errorMsg={} exceptionClass={}", new Object[]{field.getName(), sourceObject.getClass().getName(), e.getMessage(), e.getClass().getSimpleName(), e});
                try {
                    field.set(sourceObject, null);
                    log.warn("[Decrypt] [\u5b57\u6bb5\u91cd\u7f6e] [success] [warn] [unknown] fieldName={} className={} message=\u5b57\u6bb5\u5df2\u7f6e\u7a7a", (Object)field.getName(), (Object)sourceObject.getClass().getName());
                }
                catch (Exception e2) {
                    log.error("[Decrypt] [\u5b57\u6bb5\u91cd\u7f6e\u5f02\u5e38] [failure] [error] [unknown] fieldName={} className={} errorMsg={} exceptionClass={}", new Object[]{field.getName(), sourceObject.getClass().getName(), e2.getMessage(), e2.getClass().getSimpleName(), e2});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decryptField(String value, Field field) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return value;
        }
        if (value.length() <= 14 || !StrUtil.startWith((CharSequence)value, (CharSequence)"VI*D#S")) {
            return value;
        }
        if (ObjectUtils.isNull((Object)((Object)this.cachedAlgorithmType))) {
            MybatisDecryptInterceptor mybatisDecryptInterceptor = this;
            synchronized (mybatisDecryptInterceptor) {
                if (ObjectUtils.isNull((Object)((Object)this.cachedAlgorithmType))) {
                    this.cachedAlgorithmType = AlgorithmType.getByName(this.fieldEncryptionProperties.getAlgorithm());
                    this.cachedMiddlewareEnabled = this.fieldEncryptionProperties.getMiddlewareEnabled();
                    this.cachedGroupConfig = this.fieldEncryptionProperties.getMaxVersionGroupConfig();
                }
            }
        }
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setMiddlewareEnabled(this.cachedMiddlewareEnabled);
        encryptContext.setAlgorithm(this.cachedAlgorithmType);
        DataProcessingMethodsType processingType = FIELD_ANNOTATION_CACHE.computeIfAbsent(field, f -> {
            EncryptField encryptField = f.getAnnotation(EncryptField.class);
            return ObjectUtils.isNotNull((Object)encryptField) && ObjectUtils.isNotNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? encryptField.dataProcessingMethodsType() : DataProcessingMethodsType.ACCURATE;
        });
        encryptContext.setDataProcessingMethodsType(processingType);
        encryptContext.setVersion(this.cachedGroupConfig.getVersion());
        encryptContext.setPassword(this.cachedGroupConfig.getPassword());
        encryptContext.setPublicKey(this.cachedGroupConfig.getPublicKey());
        encryptContext.setPrivateKey(this.cachedGroupConfig.getPrivateKey());
        return this.encryptorManager.decrypt(value, encryptContext);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

