/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.filter;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.encrypt.config.properties.ApiDecryptProperties;
import cn.smarthse.framework.encrypt.domain.EncryptVo;
import cn.smarthse.framework.encrypt.filter.DecryptRequestBodyWrapper;
import cn.smarthse.framework.encrypt.filter.EncryptResponseBodyWrapper;
import cn.smarthse.framework.json.utils.JsonUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.http.HttpMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CryptoFilter
implements Filter {
    private final ApiDecryptProperties properties;

    public CryptoFilter(ApiDecryptProperties properties) {
        this.properties = properties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        ApiEncrypt apiEncrypt = this.getApiEncryptAnnotation(servletRequest);
        if (ObjectUtils.isNull((Object)apiEncrypt)) {
            chain.doFilter(request, response);
            return;
        }
        boolean requestFlag = apiEncrypt.request();
        boolean responseFlag = apiEncrypt.response();
        Object requestWrapper = null;
        EncryptResponseBodyWrapper responseWrapper = null;
        EncryptResponseBodyWrapper responseBodyWrapper = null;
        if (HttpMethod.PUT.matches(servletRequest.getMethod()) || HttpMethod.POST.matches(servletRequest.getMethod())) {
            if (requestFlag) {
                String headerValue = servletRequest.getHeader(this.properties.getHeaderFlag());
                if (StrUtil.isNotBlank((CharSequence)headerValue)) {
                    requestWrapper = new DecryptRequestBodyWrapper(servletRequest, this.properties.getPrivateKey(), this.properties.getHeaderFlag());
                } else if (ObjectUtils.isNotNull((Object)apiEncrypt)) {
                    HandlerExceptionResolver exceptionResolver = (HandlerExceptionResolver)SpringUtils.getBean((String)"handlerExceptionResolver", HandlerExceptionResolver.class);
                    exceptionResolver.resolveException(servletRequest, servletResponse, null, (Exception)new ServiceException("\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743"));
                    return;
                }
            } else {
                requestWrapper = servletRequest;
            }
        }
        if (responseFlag) {
            responseWrapper = responseBodyWrapper = new EncryptResponseBodyWrapper(servletResponse);
        }
        chain.doFilter((ServletRequest)ObjectUtils.defaultIfNull((Object)requestWrapper, (Object)request), (ServletResponse)ObjectUtils.defaultIfNull((Object)((Object)responseWrapper), (Object)response));
        if (responseFlag) {
            servletResponse.reset();
            servletResponse.setContentType("application/json");
            EncryptVo encryptVo = responseBodyWrapper.getEncryptPassword(servletResponse, this.properties.getPublicKey(), this.properties.getHeaderFlag());
            servletResponse.getWriter().write(Objects.requireNonNull(JsonUtils.toJsonString((Object)encryptVo)));
        }
    }

    private ApiEncrypt getApiEncryptAnnotation(HttpServletRequest servletRequest) {
        RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)SpringUtils.getBean((String)"requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        try {
            Object handler;
            HandlerExecutionChain mappingHandler = handlerMapping.getHandler(servletRequest);
            if (ObjectUtils.isNotNull((Object)mappingHandler) && ObjectUtils.isNotNull((Object)(handler = mappingHandler.getHandler())) && handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                return (ApiEncrypt)handlerMethod.getMethodAnnotation(ApiEncrypt.class);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public void destroy() {
    }
}

