/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.asymmetric.SM2;
import cn.smarthse.core.wcsp.utils.WcspEncryptionUtils;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.encrypt.config.properties.FieldEncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptUtils.class);
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";

    public static FieldEncryptorProperties getFieldEncryptorProperties() {
        return EncryptorPropertiesHolder.INSTANCE;
    }

    public static EncryptorManager getEncryptorManager() {
        return EncryptorManagerHolder.INSTANCE;
    }

    public static Map<String, EncryptContext> getEncryptContext() {
        return EncryptContextHolder.INSTANCE_MAP;
    }

    private static EncryptContext createEncryptContext(FieldEncryptorProperties.GroupConfig versionGroupConfig) {
        FieldEncryptorProperties fieldEncryptionProperties = EncryptUtils.getFieldEncryptorProperties();
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setAlgorithm(fieldEncryptionProperties.getAlgorithm());
        encryptContext.setEncode(EncodeType.BASE64);
        encryptContext.setDataProcessingMethodsType(DataProcessingMethodsType.ACCURATE);
        if (Objects.isNull(versionGroupConfig)) {
            versionGroupConfig = fieldEncryptionProperties.getMaxVersionGroupConfig();
        }
        encryptContext.setVersion(versionGroupConfig.getVersion());
        encryptContext.setPassword(versionGroupConfig.getPassword());
        encryptContext.setPublicKey(versionGroupConfig.getPublicKey());
        encryptContext.setPrivateKey(versionGroupConfig.getPrivateKey());
        return encryptContext;
    }

    public static EncryptContext getWcspEncryptContext() {
        return WcspEncryptContextHolder.INSTANCE;
    }

    private static EncryptContext createWcspEncryptContext() {
        FieldEncryptorProperties fieldEncryptionProperties = EncryptUtils.getFieldEncryptorProperties();
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setAlgorithm(fieldEncryptionProperties.getAlgorithm());
        encryptContext.setEncode(EncodeType.BASE64);
        encryptContext.setDataProcessingMethodsType(DataProcessingMethodsType.ACCURATE);
        encryptContext.setWcspAlias(fieldEncryptionProperties.getWcspAlias());
        encryptContext.setWcspDescription(fieldEncryptionProperties.getWcspDescription());
        encryptContext.setWcspVersion(fieldEncryptionProperties.getWcspVersion());
        return encryptContext;
    }

    public static String encryptIncludeEncryptContext(String value) {
        FieldEncryptorProperties properties = EncryptUtils.getFieldEncryptorProperties();
        if (!Objects.equals(properties.getEnable(), true)) {
            return value;
        }
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6\uff01\uff01\uff01");
            return value;
        }
        if (properties.getAlgorithm() == AlgorithmType.SM4) {
            return EncryptUtils.getEncryptorManager().encrypt(value, EncryptUtils.getEncryptContext().get(properties.getMaxVersionGroupConfig().getVersion()));
        }
        if (properties.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE) {
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            if (data.length > 1023) {
                throw new IllegalArgumentException("Input data is too long");
            }
            return EncryptUtils.getEncryptorManager().encrypt(value, EncryptUtils.getWcspEncryptContext());
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
    }

    public static String decryptIncludeEncryptContext(String value) {
        FieldEncryptorProperties properties = EncryptUtils.getFieldEncryptorProperties();
        if (!Objects.equals(properties.getEnable(), true)) {
            return value;
        }
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (value.length() <= 14 || !StrUtil.startWith((CharSequence)value, (CharSequence)"VI*D#S")) {
            return value;
        }
        if (properties.getAlgorithm() == AlgorithmType.SM4) {
            String version = StrUtil.subPre((CharSequence)value, (int)14);
            FieldEncryptorProperties.GroupConfig versionGroupConfig = properties.getGroupConfigs().stream().filter(groupConfig -> StrUtil.equals((CharSequence)groupConfig.getVersion(), (CharSequence)version)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u89e3\u5bc6\u672a\u627e\u5230\u5bf9\u5e94\u7248\u672c\uff1a" + version + "\uff0c\u539f\u59cb\u503c\uff1a" + value));
            return EncryptUtils.getEncryptorManager().decrypt(value, EncryptUtils.getEncryptContext().get(versionGroupConfig.getVersion()));
        }
        if (properties.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE) {
            return EncryptUtils.getEncryptorManager().decrypt(value, EncryptUtils.getWcspEncryptContext());
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
    }

    public static String encryptByMd5(String data) {
        return SecureUtil.md5((String)data);
    }

    public static String encryptBySha256(String data) {
        return SecureUtil.sha256((String)data);
    }

    public static String encryptBySm3(String data) {
        return SmUtil.sm3((String)data);
    }

    public static String encryptByBase64(String data) {
        return Base64.encode((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public static String decryptByBase64(String data) {
        return Base64.decodeStr((CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    public static Map<String, String> generateRsaKey() {
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        RSA rsa = SecureUtil.rsa();
        keyMap.put(PRIVATE_KEY, rsa.getPrivateKeyBase64());
        keyMap.put(PUBLIC_KEY, rsa.getPublicKeyBase64());
        return keyMap;
    }

    public static String encryptByRsa(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        RSA rsa = SecureUtil.rsa(null, (String)publicKey);
        return rsa.encryptBase64(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String encryptByRsaHex(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        RSA rsa = SecureUtil.rsa(null, (String)publicKey);
        return rsa.encryptHex(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String decryptByRsa(String data, String privateKey) {
        if (StrUtil.isBlank((CharSequence)privateKey)) {
            throw new IllegalArgumentException("RSA\u9700\u8981\u4f20\u5165\u79c1\u94a5\u8fdb\u884c\u89e3\u5bc6");
        }
        RSA rsa = SecureUtil.rsa((String)privateKey, null);
        return rsa.decryptStr(data, KeyType.PrivateKey, StandardCharsets.UTF_8);
    }

    public static Map<String, String> generateSm2Key() {
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        SM2 sm2 = SmUtil.sm2();
        keyMap.put(PRIVATE_KEY, sm2.getPrivateKeyBase64());
        keyMap.put(PUBLIC_KEY, sm2.getPublicKeyBase64());
        return keyMap;
    }

    public static String encryptBySm2(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("SM2\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        SM2 sm2 = SmUtil.sm2(null, (String)publicKey);
        return sm2.encryptBase64(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String encryptBySm2Hex(String data, String publicKey) {
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("SM2\u9700\u8981\u4f20\u5165\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6");
        }
        SM2 sm2 = SmUtil.sm2(null, (String)publicKey);
        return sm2.encryptHex(data, StandardCharsets.UTF_8, KeyType.PublicKey);
    }

    public static String decryptBySm2(String data, String privateKey) {
        if (StrUtil.isBlank((CharSequence)privateKey)) {
            throw new IllegalArgumentException("SM2\u9700\u8981\u4f20\u5165\u79c1\u94a5\u8fdb\u884c\u89e3\u5bc6");
        }
        SM2 sm2 = SmUtil.sm2((String)privateKey, null);
        return sm2.decryptStr(data, KeyType.PrivateKey, StandardCharsets.UTF_8);
    }

    public static String encryptByAes(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptBase64(data, StandardCharsets.UTF_8);
    }

    public static String encryptByAesHex(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptHex(data, StandardCharsets.UTF_8);
    }

    public static String decryptByAes(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d");
        }
        return SecureUtil.aes((byte[])password.getBytes(StandardCharsets.UTF_8)).decryptStr(data, StandardCharsets.UTF_8);
    }

    public static String encryptBySm4(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int sm4PasswordLength = 16;
        if (sm4PasswordLength != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d");
        }
        return SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptBase64(data, StandardCharsets.UTF_8);
    }

    public static String encryptBySm4Hex(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int sm4PasswordLength = 16;
        if (sm4PasswordLength != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d");
        }
        return SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8)).encryptHex(data, StandardCharsets.UTF_8);
    }

    public static String decryptBySm4(String data, String password) {
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u9700\u8981\u4f20\u5165\u79d8\u94a5\u4fe1\u606f");
        }
        int sm4PasswordLength = 16;
        if (sm4PasswordLength != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u8981\u6c42\u4e3a16\u4f4d");
        }
        return SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8)).decryptStr(data, StandardCharsets.UTF_8);
    }

    public static String encryptByWcspLightDataService(String data, String alias, String description) {
        return WcspEncryptionUtils.encryptByWcspLightDataService((String)data, (String)alias, (String)description);
    }

    public static String encryptByWcspLightDataService(String data) {
        FieldEncryptorProperties properties = EncryptUtils.getFieldEncryptorProperties();
        return properties.getEnable() != false ? EncryptUtils.encryptByWcspLightDataService(data, properties.getWcspAlias(), properties.getWcspDescription()) : data;
    }

    public static String encryptByWcspLightDataServiceHex(String data, String alias, String description) {
        return WcspEncryptionUtils.encryptByWcspLightDataServiceHex((String)data, (String)alias, (String)description);
    }

    public static String encryptByWcspLightDataServiceHex(String data) {
        FieldEncryptorProperties properties = EncryptUtils.getFieldEncryptorProperties();
        return properties.getEnable() != false ? EncryptUtils.encryptByWcspLightDataServiceHex(data, properties.getWcspAlias(), properties.getWcspDescription()) : data;
    }

    public static String decryptByWcspLightDataService(String data, String alias, String description) {
        return WcspEncryptionUtils.decryptByWcspLightDataService((String)data, (String)alias, (String)description);
    }

    public static String decryptByWcspLightDataService(String data) {
        FieldEncryptorProperties properties = EncryptUtils.getFieldEncryptorProperties();
        return properties.getEnable() != false ? EncryptUtils.decryptByWcspLightDataService(data, properties.getWcspAlias(), properties.getWcspDescription()) : data;
    }

    public static String decryptByWcspLightDataServiceHex(String data, String alias, String description) {
        return WcspEncryptionUtils.decryptByWcspLightDataServiceHex((String)data, (String)alias, (String)description);
    }

    public static String decryptByWcspLightDataServiceHex(String data) {
        FieldEncryptorProperties properties = EncryptUtils.getFieldEncryptorProperties();
        return properties.getEnable() != false ? EncryptUtils.decryptByWcspLightDataServiceHex(data, properties.getWcspAlias(), properties.getWcspDescription()) : data;
    }

    @Generated
    private EncryptUtils() {
    }

    private static class EncryptorPropertiesHolder {
        private static final FieldEncryptorProperties INSTANCE = (FieldEncryptorProperties)SpringUtils.getBean(FieldEncryptorProperties.class);

        private EncryptorPropertiesHolder() {
        }
    }

    private static class EncryptorManagerHolder {
        private static final EncryptorManager INSTANCE = (EncryptorManager)SpringUtils.getBean(EncryptorManager.class);

        private EncryptorManagerHolder() {
        }
    }

    private static class EncryptContextHolder {
        private static final Map<String, EncryptContext> INSTANCE_MAP = new ConcurrentHashMap<String, EncryptContext>();

        private EncryptContextHolder() {
        }

        static {
            FieldEncryptorProperties fieldEncryptorProperties = EncryptUtils.getFieldEncryptorProperties();
            if (CollUtil.isEmpty(fieldEncryptorProperties.getGroupConfigs())) {
                throw new IllegalArgumentException("\u8bf7\u914d\u7f6e\u52a0\u5bc6\u7248\u672c");
            }
            for (FieldEncryptorProperties.GroupConfig config : fieldEncryptorProperties.getGroupConfigs()) {
                INSTANCE_MAP.put(config.getVersion(), EncryptUtils.createEncryptContext(config));
            }
        }
    }

    private static class WcspEncryptContextHolder {
        private static final EncryptContext INSTANCE = EncryptUtils.createWcspEncryptContext();

        private WcspEncryptContextHolder() {
        }
    }
}

