/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.core.encryptor;

import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.encryptor.AbstractEncryptor;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import cn.smarthse.framework.encrypt.utils.EncryptUtils;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WcspLightDataServiceEncryptor
extends AbstractEncryptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspLightDataServiceEncryptor.class);
    private final EncryptContext context;

    public WcspLightDataServiceEncryptor(EncryptContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.WCSP_LIGHT_DATA_SERVICE;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        String wcspAlias = this.context.getWcspAlias();
        String wcspDescription = this.context.getWcspDescription();
        int maxRetries = 3;
        Supplier<String> encryptOperation = () -> {
            if (encodeType == EncodeType.HEX) {
                return EncryptUtils.encryptByWcspLightDataServiceHex(value, wcspAlias, wcspDescription);
            }
            return EncryptUtils.encryptByWcspLightDataService(value, wcspAlias, wcspDescription);
        };
        for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
            try {
                return encryptOperation.get();
            }
            catch (Exception e) {
                if (retryCount != maxRetries - 1) continue;
                log.error("\u52a0\u5bc6\u64cd\u4f5c\u91cd\u8bd5" + maxRetries + "\u6b21\u540e\u4ecd\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u52a0\u5bc6\u64cd\u4f5c\u91cd\u8bd5" + maxRetries + "\u6b21\u540e\u4ecd\u5931\u8d25", e.getCause());
            }
        }
        return null;
    }

    @Override
    public String decrypt(String value) {
        return this.decrypt(value, this.context.getEncode());
    }

    @Override
    public String decrypt(String value, EncodeType encodeType) {
        String wcspAlias = this.context.getWcspAlias();
        String wcspDescription = this.context.getWcspDescription();
        int maxRetries = 3;
        Supplier<String> encryptOperation = () -> {
            if (encodeType == EncodeType.HEX) {
                return EncryptUtils.decryptByWcspLightDataServiceHex(value, wcspAlias, wcspDescription);
            }
            return EncryptUtils.decryptByWcspLightDataService(value, wcspAlias, wcspDescription);
        };
        for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
            try {
                return encryptOperation.get();
            }
            catch (Exception e) {
                if (retryCount != maxRetries - 1) continue;
                log.error("\u89e3\u5bc6\u64cd\u4f5c\u91cd\u8bd5" + maxRetries + "\u6b21\u540e\u4ecd\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u89e3\u5bc6\u64cd\u4f5c\u91cd\u8bd5" + maxRetries + "\u6b21\u540e\u4ecd\u5931\u8d25", e.getCause());
            }
        }
        return null;
    }
}

