/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.config;

import cn.smarthse.core.wcsp.context.WcspContext;
import cn.smarthse.core.wcsp.pool.WcspServicePlatformPool;
import cn.smarthse.core.wcsp.utils.WcspEncryptionUtils;
import cn.smarthse.framework.encrypt.config.properties.FieldEncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.interceptor.MybatisDecryptInterceptor;
import cn.smarthse.framework.encrypt.interceptor.MybatisEncryptInterceptor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={FieldEncryptorProperties.class})
public class FieldEncryptorAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptorAutoConfig.class);
    private final FieldEncryptorProperties fieldEncryptionProperties;

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
    public EncryptorManager encryptorManager() {
        log.info("\u521d\u59cb\u5316 EncryptorManager \u914d\u7f6e");
        return new EncryptorManager(this.fieldEncryptionProperties.getTypeAliasesPackage());
    }

    @Bean(destroyMethod="close")
    @ConditionalOnBean(value={EncryptorManager.class})
    @ConditionalOnProperty(value={"mybatis-encryptor.algorithm"}, havingValue="WCSP_LIGHT_DATA_SERVICE")
    public WcspServicePlatformPool wcspServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptionUtils \u914d\u7f6e");
        WcspContext wcspContext = new WcspContext();
        wcspContext.setWcspUrl(this.fieldEncryptionProperties.getWcspUrl());
        wcspContext.setWcspTenantId(this.fieldEncryptionProperties.getWcspTenantId());
        wcspContext.setWcspAppId(this.fieldEncryptionProperties.getWcspAppId());
        wcspContext.setWcspSecret(this.fieldEncryptionProperties.getWcspSecret());
        wcspContext.setWcspWorkDir(this.fieldEncryptionProperties.getWcspWorkDir());
        wcspContext.setWcspPoolMaxTotal(this.fieldEncryptionProperties.getWcspPoolMaxTotal());
        wcspContext.setWcspPoolMaxIdle(this.fieldEncryptionProperties.getWcspPoolMaxIdle());
        wcspContext.setWcspPoolMinIdle(this.fieldEncryptionProperties.getWcspPoolMinIdle());
        wcspContext.setWcspPoolMaxWaitMillis(this.fieldEncryptionProperties.getWcspPoolMaxWaitMillis());
        wcspContext.setWcspAlias(this.fieldEncryptionProperties.getWcspAlias());
        wcspContext.setWcspDescription(this.fieldEncryptionProperties.getWcspDescription());
        wcspContext.setWcspVersion(this.fieldEncryptionProperties.getWcspVersion());
        WcspServicePlatformPool pool = new WcspServicePlatformPool(wcspContext);
        WcspEncryptionUtils.initialize((WcspServicePlatformPool)pool);
        return pool;
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
    public MybatisEncryptInterceptor mybatisEncryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisEncryptInterceptor \u914d\u7f6e");
        return new MybatisEncryptInterceptor(encryptorManager, this.fieldEncryptionProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
    public MybatisDecryptInterceptor mybatisDecryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisDecryptInterceptor \u914d\u7f6e");
        return new MybatisDecryptInterceptor(encryptorManager, this.fieldEncryptionProperties);
    }

    @Generated
    public FieldEncryptorAutoConfig(FieldEncryptorProperties fieldEncryptionProperties) {
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }
}

