/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.core.encryptor;

import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.encryptor.AbstractEncryptor;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import cn.smarthse.framework.encrypt.utils.EncryptUtils;
import org.apache.commons.lang3.StringUtils;

public class Sm2Encryptor
extends AbstractEncryptor {
    private final EncryptContext context;

    public Sm2Encryptor(EncryptContext context) {
        super(context);
        String privateKey = context.getPrivateKey();
        String publicKey = context.getPublicKey();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{privateKey, publicKey})) {
            throw new IllegalArgumentException("SM2\u516c\u79c1\u94a5\u5747\u9700\u8981\u63d0\u4f9b\uff0c\u516c\u94a5\u52a0\u5bc6\uff0c\u79c1\u94a5\u89e3\u5bc6\u3002");
        }
        this.context = context;
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.SM2;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        if (encodeType == EncodeType.HEX) {
            return EncryptUtils.encryptBySm2Hex(value, this.context.getPublicKey());
        }
        return EncryptUtils.encryptBySm2(value, this.context.getPublicKey());
    }

    @Override
    public String decrypt(String value) {
        return EncryptUtils.decryptBySm2(value, this.context.getPrivateKey());
    }
}

