/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.encrypt.enumd.EncodeType;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class MybatisDecryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisDecryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final EncryptorProperties encryptorProperties;

    public MybatisDecryptInterceptor(EncryptorManager encryptorManager, EncryptorProperties encryptorProperties) {
        this.encryptorManager = encryptorManager;
        this.encryptorProperties = encryptorProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        ParameterHandler parameterHandler;
        Object parameterObject;
        ResultSetHandler resultSetHandler = (ResultSetHandler)invocation.getTarget();
        Field parameterHandlerField = resultSetHandler.getClass().getDeclaredField("parameterHandler");
        parameterHandlerField.setAccessible(true);
        Object target = parameterHandlerField.get(resultSetHandler);
        if (target instanceof ParameterHandler && ObjectUtil.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            this.decryptHandler(parameterObject);
        }
        if ((result = invocation.proceed()) == null) {
            return null;
        }
        this.decryptHandler(result);
        return result;
    }

    private void decryptHandler(Object sourceObject) {
        if (ObjectUtil.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            new HashSet(map.values()).forEach(this::decryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtil.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::decryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtil.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            try {
                field.set(sourceObject, this.decryptField(Convert.toStr((Object)field.get(sourceObject)), field));
            }
            catch (IllegalArgumentException e) {
                this.handleDecryptionError(sourceObject, field, e, "\u89e3\u5bc6\u5b57\u6bb5\u5931\u8d25 IllegalArgumentException");
            }
            catch (Exception e) {
                this.handleDecryptionError(sourceObject, field, e, "\u89e3\u5bc6\u5b57\u6bb5\u5931\u8d25\uff0c\u5904\u7406\u5b57\u6bb5\u65f6\u53d1\u751f\u4e25\u91cd\u5f02\u5e38 Exception");
            }
        }
    }

    private void handleDecryptionError(Object sourceObject, Field field, Exception e, String message) {
        log.error("{}\uff1a\u5b57\u6bb5[{}]\uff0c\u5bf9\u8c61[{}]", new Object[]{message, field.getName(), sourceObject.getClass().getName(), e});
        try {
            field.set(sourceObject, null);
        }
        catch (Exception e2) {
            log.error("\u89e3\u5bc6\u5b57\u6bb5\u5931\u8d25\uff1a\u5b57\u6bb5[{}]\u7f6e\u7a7a\u5931\u8d25\uff0c\u5bf9\u8c61[{}]", new Object[]{field.getName(), sourceObject.getClass().getName(), e2});
        }
    }

    private String decryptField(String value, Field field) {
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        if (value.length() <= 14 || !StrUtil.startWith((CharSequence)value, (CharSequence)"VI*D#S")) {
            return value;
        }
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setAlgorithm(this.encryptorProperties.getAlgorithm());
        encryptContext.setEncode(EncodeType.BASE64);
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        encryptContext.setDataProcessingMethodsType(ObjectUtil.isNotNull((Object)encryptField) && ObjectUtil.isNotNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? encryptField.dataProcessingMethodsType() : DataProcessingMethodsType.VAGUE);
        if (encryptContext.getAlgorithm() == AlgorithmType.WCSP_LIGHT_DATA_SERVICE) {
            encryptContext.setWcspApiKey(this.encryptorProperties.getWcspApiKey());
            encryptContext.setWcspSecretKey(this.encryptorProperties.getWcspSecretKey());
            encryptContext.setWcspVersion(this.encryptorProperties.getWcspVersion());
            encryptContext.setWcspLocalHostEncryptUrl(this.encryptorProperties.getWcspLocalHostEncryptUrl());
            encryptContext.setWcspLocalHostDecryptUrl(this.encryptorProperties.getWcspLocalHostDecryptUrl());
        } else {
            String version = StrUtil.subPre((CharSequence)value, (int)14);
            EncryptorProperties.GroupConfig versionGroupConfig = this.encryptorProperties.getGroupConfigs().stream().filter(groupConfig -> StrUtil.equals((CharSequence)groupConfig.getVersion(), (CharSequence)version)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u89e3\u5bc6\u672a\u627e\u5230\u5bf9\u5e94\u7248\u672c\uff1a" + version + "\uff0c\u539f\u59cb\u503c\uff1a" + value));
            encryptContext.setVersion(versionGroupConfig.getVersion());
            encryptContext.setPassword(versionGroupConfig.getPassword());
            encryptContext.setPublicKey(versionGroupConfig.getPublicKey());
            encryptContext.setPrivateKey(versionGroupConfig.getPrivateKey());
        }
        return this.encryptorManager.decrypt(value, encryptContext);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

