/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.filter;

import cn.hutool.core.util.RandomUtil;
import cn.smarthse.framework.core.utils.SecurityHeaderUtil;
import cn.smarthse.framework.encrypt.domain.EncryptVo;
import cn.smarthse.framework.encrypt.utils.EncryptUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;

public class EncryptResponseBodyWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final ServletOutputStream servletOutputStream = this.getOutputStream();
    private final PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.byteArrayOutputStream));

    public EncryptResponseBodyWrapper(HttpServletResponse response) throws IOException {
        super(response);
    }

    public PrintWriter getWriter() {
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public void reset() {
        this.byteArrayOutputStream.reset();
    }

    public byte[] getResponseData() throws IOException {
        this.flushBuffer();
        return this.byteArrayOutputStream.toByteArray();
    }

    public String getContent() throws IOException {
        this.flushBuffer();
        return this.byteArrayOutputStream.toString();
    }

    public EncryptVo getEncryptPassword(HttpServletResponse servletResponse, String publicKey, String headerFlag) throws IOException {
        String sm4Password = RandomUtil.randomString((int)16);
        String encryptSm4 = EncryptUtils.encryptByBase64(sm4Password);
        String encryptPassword = EncryptUtils.encryptBySm2(encryptSm4, publicKey);
        servletResponse.addHeader("Access-Control-Expose-Headers", headerFlag);
        servletResponse.setHeader("Access-Control-Allow-Origin", "*");
        servletResponse.setHeader("Access-Control-Allow-Methods", "*");
        servletResponse.setHeader(headerFlag, encryptPassword);
        SecurityHeaderUtil.setSecurityHeaders((HttpServletResponse)servletResponse);
        servletResponse.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        String originalBody = this.getContent();
        EncryptVo encryptVo = new EncryptVo();
        encryptVo.setCode(HttpStatus.OK);
        encryptVo.setEp(encryptPassword);
        encryptVo.setResult(EncryptUtils.encryptBySm4(originalBody, sm4Password));
        return encryptVo;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                EncryptResponseBodyWrapper.this.byteArrayOutputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                EncryptResponseBodyWrapper.this.byteArrayOutputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                EncryptResponseBodyWrapper.this.byteArrayOutputStream.write(b, off, len);
            }
        };
    }
}

