/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.config.properties;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="mybatis-encryptor")
public class EncryptorProperties {
    private Boolean enable;
    private AlgorithmType algorithm;
    private String typeAliasesPackage;
    private List<GroupConfig> groupConfigs = new ArrayList<GroupConfig>();
    private String wcspApiKey;
    private String wcspSecretKey;
    private String wcspVersion = "VI*D#S20250721";
    private String wcspLocalHostEncryptUrl;
    private String wcspLocalHostDecryptUrl;
    private GroupConfig maxVersionGroupConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupConfig getMaxVersionGroupConfig() {
        if (Objects.nonNull(this.maxVersionGroupConfig)) {
            return this.maxVersionGroupConfig;
        }
        if (CollUtil.isEmpty(this.groupConfigs)) {
            return null;
        }
        EncryptorProperties encryptorProperties = this;
        synchronized (encryptorProperties) {
            if (Objects.isNull(this.maxVersionGroupConfig)) {
                this.computeMaxVersionGroupConfig();
            }
        }
        return this.maxVersionGroupConfig;
    }

    private void computeMaxVersionGroupConfig() {
        if (CollUtil.isEmpty(this.groupConfigs)) {
            return;
        }
        this.maxVersionGroupConfig = this.groupConfigs.stream().max(Comparator.comparingInt(groupConfig -> Convert.toInt((Object)StrUtil.subSuf((CharSequence)groupConfig.getVersion(), (int)6)))).orElse(null);
    }

    public void setGroupConfigs(List<GroupConfig> groupConfigs) {
        this.groupConfigs = groupConfigs;
        this.maxVersionGroupConfig = null;
    }

    @Generated
    public EncryptorProperties() {
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    @Generated
    public List<GroupConfig> getGroupConfigs() {
        return this.groupConfigs;
    }

    @Generated
    public String getWcspApiKey() {
        return this.wcspApiKey;
    }

    @Generated
    public String getWcspSecretKey() {
        return this.wcspSecretKey;
    }

    @Generated
    public String getWcspVersion() {
        return this.wcspVersion;
    }

    @Generated
    public String getWcspLocalHostEncryptUrl() {
        return this.wcspLocalHostEncryptUrl;
    }

    @Generated
    public String getWcspLocalHostDecryptUrl() {
        return this.wcspLocalHostDecryptUrl;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    @Generated
    public void setWcspApiKey(String wcspApiKey) {
        this.wcspApiKey = wcspApiKey;
    }

    @Generated
    public void setWcspSecretKey(String wcspSecretKey) {
        this.wcspSecretKey = wcspSecretKey;
    }

    @Generated
    public void setWcspVersion(String wcspVersion) {
        this.wcspVersion = wcspVersion;
    }

    @Generated
    public void setWcspLocalHostEncryptUrl(String wcspLocalHostEncryptUrl) {
        this.wcspLocalHostEncryptUrl = wcspLocalHostEncryptUrl;
    }

    @Generated
    public void setWcspLocalHostDecryptUrl(String wcspLocalHostDecryptUrl) {
        this.wcspLocalHostDecryptUrl = wcspLocalHostDecryptUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptorProperties)) {
            return false;
        }
        EncryptorProperties other = (EncryptorProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        AlgorithmType this$algorithm = this.getAlgorithm();
        AlgorithmType other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        String this$typeAliasesPackage = this.getTypeAliasesPackage();
        String other$typeAliasesPackage = other.getTypeAliasesPackage();
        if (this$typeAliasesPackage == null ? other$typeAliasesPackage != null : !this$typeAliasesPackage.equals(other$typeAliasesPackage)) {
            return false;
        }
        List<GroupConfig> this$groupConfigs = this.getGroupConfigs();
        List<GroupConfig> other$groupConfigs = other.getGroupConfigs();
        if (this$groupConfigs == null ? other$groupConfigs != null : !((Object)this$groupConfigs).equals(other$groupConfigs)) {
            return false;
        }
        String this$wcspApiKey = this.getWcspApiKey();
        String other$wcspApiKey = other.getWcspApiKey();
        if (this$wcspApiKey == null ? other$wcspApiKey != null : !this$wcspApiKey.equals(other$wcspApiKey)) {
            return false;
        }
        String this$wcspSecretKey = this.getWcspSecretKey();
        String other$wcspSecretKey = other.getWcspSecretKey();
        if (this$wcspSecretKey == null ? other$wcspSecretKey != null : !this$wcspSecretKey.equals(other$wcspSecretKey)) {
            return false;
        }
        String this$wcspVersion = this.getWcspVersion();
        String other$wcspVersion = other.getWcspVersion();
        if (this$wcspVersion == null ? other$wcspVersion != null : !this$wcspVersion.equals(other$wcspVersion)) {
            return false;
        }
        String this$wcspLocalHostEncryptUrl = this.getWcspLocalHostEncryptUrl();
        String other$wcspLocalHostEncryptUrl = other.getWcspLocalHostEncryptUrl();
        if (this$wcspLocalHostEncryptUrl == null ? other$wcspLocalHostEncryptUrl != null : !this$wcspLocalHostEncryptUrl.equals(other$wcspLocalHostEncryptUrl)) {
            return false;
        }
        String this$wcspLocalHostDecryptUrl = this.getWcspLocalHostDecryptUrl();
        String other$wcspLocalHostDecryptUrl = other.getWcspLocalHostDecryptUrl();
        if (this$wcspLocalHostDecryptUrl == null ? other$wcspLocalHostDecryptUrl != null : !this$wcspLocalHostDecryptUrl.equals(other$wcspLocalHostDecryptUrl)) {
            return false;
        }
        GroupConfig this$maxVersionGroupConfig = this.getMaxVersionGroupConfig();
        GroupConfig other$maxVersionGroupConfig = other.getMaxVersionGroupConfig();
        return !(this$maxVersionGroupConfig == null ? other$maxVersionGroupConfig != null : !((Object)this$maxVersionGroupConfig).equals(other$maxVersionGroupConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EncryptorProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        AlgorithmType $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        String $typeAliasesPackage = this.getTypeAliasesPackage();
        result = result * 59 + ($typeAliasesPackage == null ? 43 : $typeAliasesPackage.hashCode());
        List<GroupConfig> $groupConfigs = this.getGroupConfigs();
        result = result * 59 + ($groupConfigs == null ? 43 : ((Object)$groupConfigs).hashCode());
        String $wcspApiKey = this.getWcspApiKey();
        result = result * 59 + ($wcspApiKey == null ? 43 : $wcspApiKey.hashCode());
        String $wcspSecretKey = this.getWcspSecretKey();
        result = result * 59 + ($wcspSecretKey == null ? 43 : $wcspSecretKey.hashCode());
        String $wcspVersion = this.getWcspVersion();
        result = result * 59 + ($wcspVersion == null ? 43 : $wcspVersion.hashCode());
        String $wcspLocalHostEncryptUrl = this.getWcspLocalHostEncryptUrl();
        result = result * 59 + ($wcspLocalHostEncryptUrl == null ? 43 : $wcspLocalHostEncryptUrl.hashCode());
        String $wcspLocalHostDecryptUrl = this.getWcspLocalHostDecryptUrl();
        result = result * 59 + ($wcspLocalHostDecryptUrl == null ? 43 : $wcspLocalHostDecryptUrl.hashCode());
        GroupConfig $maxVersionGroupConfig = this.getMaxVersionGroupConfig();
        result = result * 59 + ($maxVersionGroupConfig == null ? 43 : ((Object)$maxVersionGroupConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EncryptorProperties(enable=" + this.getEnable() + ", algorithm=" + String.valueOf((Object)this.getAlgorithm()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", groupConfigs=" + String.valueOf(this.getGroupConfigs()) + ", wcspApiKey=" + this.getWcspApiKey() + ", wcspSecretKey=" + this.getWcspSecretKey() + ", wcspVersion=" + this.getWcspVersion() + ", wcspLocalHostEncryptUrl=" + this.getWcspLocalHostEncryptUrl() + ", wcspLocalHostDecryptUrl=" + this.getWcspLocalHostDecryptUrl() + ", maxVersionGroupConfig=" + String.valueOf(this.getMaxVersionGroupConfig()) + ")";
    }

    public static class GroupConfig {
        private String version;
        private String password;
        private String publicKey;
        private String privateKey;

        @Generated
        public GroupConfig() {
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getPublicKey() {
            return this.publicKey;
        }

        @Generated
        public String getPrivateKey() {
            return this.privateKey;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Generated
        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupConfig)) {
                return false;
            }
            GroupConfig other = (GroupConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$privateKey = this.getPrivateKey();
            String other$privateKey = other.getPrivateKey();
            return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EncryptorProperties.GroupConfig(version=" + this.getVersion() + ", password=" + this.getPassword() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ")";
        }
    }
}

