/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.config;

import cn.smarthse.framework.encrypt.config.properties.EncryptorProperties;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.interceptor.MybatisDecryptInterceptor;
import cn.smarthse.framework.encrypt.interceptor.MybatisEncryptInterceptor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={EncryptorProperties.class})
public class EncryptorAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptorAutoConfig.class);
    private final EncryptorProperties encryptorProperties;

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
    public EncryptorManager encryptorManager() {
        log.info("\u521d\u59cb\u5316 EncryptorManager \u914d\u7f6e");
        return new EncryptorManager(this.encryptorProperties.getTypeAliasesPackage());
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
    public MybatisEncryptInterceptor mybatisEncryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisEncryptInterceptor \u914d\u7f6e");
        return new MybatisEncryptInterceptor(encryptorManager, this.encryptorProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enable"}, havingValue="true")
    public MybatisDecryptInterceptor mybatisDecryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisDecryptInterceptor \u914d\u7f6e");
        return new MybatisDecryptInterceptor(encryptorManager, this.encryptorProperties);
    }

    @Generated
    public EncryptorAutoConfig(EncryptorProperties encryptorProperties) {
        this.encryptorProperties = encryptorProperties;
    }
}

